/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.gpsmock;

import android.location.Location;
import android.os.Build;
import android.os.Bundle;
import com.didichuxing.doraemonkit.kit.gpsmock.GpsMockProxyManager;
import com.didichuxing.doraemonkit.kit.gpsmock.LocationBuilder;
import com.didichuxing.doraemonkit.kit.gpsmock.ServiceHookManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class GpsMockManager {
    private static final String TAG = "GpsMockManager";
    private static double mLatitude = -1.0;
    private static double mLongitude = -1.0;
    private static boolean isMocking;
    private static boolean mockAMapNavLocation;
    private static boolean isFromMockProvider;
    private Bundle extras = new Bundle();

    private GpsMockManager() {
    }

    public static GpsMockManager getInstance() {
        return Holder.INSTANCE;
    }

    public void startMock() {
        isMocking = true;
    }

    public void stopMock() {
        isMocking = false;
    }

    private void mockLocation(double latitude, double longitude) {
        mLatitude = latitude;
        mLongitude = longitude;
    }

    public void mockLocationWithNotify(double latitude, double longitude) {
        this.mockLocation(latitude, longitude);
        this.mockLocationWithNotify(new LocationBuilder().setLatitude(latitude).setLongitude(longitude).build());
    }

    public void mockLocationWithNotify(Location location) {
        if (location == null) {
            return;
        }
        this.mockLocation(location.getLatitude(), location.getLongitude());
        location.setProvider("gps");
        if (this.extras.size() == 0) {
            this.extras.putInt("satellites", 9);
        }
        location.setExtras(this.extras);
        long currentTimeMillis = System.currentTimeMillis();
        location.setTime(currentTimeMillis);
        if (Build.VERSION.SDK_INT >= 17) {
            location.setElapsedRealtimeNanos(currentTimeMillis);
        }
        if (GpsMockManager.isFromMockProvider()) {
            Class<?> locationClass = location.getClass();
            try {
                Method method = locationClass.getMethod("setIsFromMockProvider", Boolean.TYPE);
                method.setAccessible(true);
                method.invoke((Object)location, true);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        GpsMockProxyManager.INSTANCE.mockLocationWithNotify(location);
    }

    public boolean isMocking() {
        return isMocking && mLongitude != -1.0 && mLatitude != -1.0;
    }

    public double getLatitude() {
        return mLatitude;
    }

    public double getLongitude() {
        return mLongitude;
    }

    public boolean isMockEnable() {
        return ServiceHookManager.INSTANCE.isHookSuccess();
    }

    public static boolean mockAMapNavLocation() {
        return mockAMapNavLocation;
    }

    public static void setMockAMapNavLocation(boolean mockAMapNavLocation) {
        GpsMockManager.mockAMapNavLocation = mockAMapNavLocation;
    }

    public static boolean isFromMockProvider() {
        return isFromMockProvider;
    }

    public static void setIsFromMockProvider(boolean isFromMockProvider) {
        GpsMockManager.isFromMockProvider = isFromMockProvider;
    }

    static {
        mockAMapNavLocation = false;
        isFromMockProvider = false;
    }

    private static class Holder {
        private static GpsMockManager INSTANCE = new GpsMockManager();

        private Holder() {
        }
    }
}

