/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.util;

import androidx.annotation.NonNull;
import androidx.collection.LruCache;
import com.didichuxing.doraemonkit.constant.CacheConstants;
import java.util.HashMap;
import java.util.Map;

public final class CacheMemoryUtils
implements CacheConstants {
    private static final int DEFAULT_MAX_COUNT = 256;
    private static final Map<String, CacheMemoryUtils> CACHE_MAP = new HashMap<String, CacheMemoryUtils>();
    private final String mCacheKey;
    private final LruCache<String, CacheValue> mMemoryCache;

    public static CacheMemoryUtils getInstance() {
        return CacheMemoryUtils.getInstance(256);
    }

    public static CacheMemoryUtils getInstance(int maxCount) {
        return CacheMemoryUtils.getInstance(String.valueOf(maxCount), maxCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CacheMemoryUtils getInstance(String cacheKey, int maxCount) {
        CacheMemoryUtils cache = CACHE_MAP.get(cacheKey);
        if (cache != null) return cache;
        Class<CacheMemoryUtils> clazz = CacheMemoryUtils.class;
        synchronized (CacheMemoryUtils.class) {
            cache = CACHE_MAP.get(cacheKey);
            if (cache != null) return cache;
            cache = new CacheMemoryUtils(cacheKey, (LruCache<String, CacheValue>)new LruCache(maxCount));
            CACHE_MAP.put(cacheKey, cache);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return cache;
        }
    }

    private CacheMemoryUtils(String cacheKey, LruCache<String, CacheValue> memoryCache) {
        this.mCacheKey = cacheKey;
        this.mMemoryCache = memoryCache;
    }

    public String toString() {
        return this.mCacheKey + "@" + Integer.toHexString(this.hashCode());
    }

    public void put(@NonNull String key, Object value) {
        this.put(key, value, -1);
    }

    public void put(@NonNull String key, Object value, int saveTime) {
        if (value == null) {
            return;
        }
        long dueTime = saveTime < 0 ? -1L : System.currentTimeMillis() + (long)(saveTime * 1000);
        this.mMemoryCache.put((Object)key, (Object)new CacheValue(dueTime, value));
    }

    public <T> T get(@NonNull String key) {
        return this.get(key, null);
    }

    public <T> T get(@NonNull String key, T defaultValue) {
        CacheValue val = (CacheValue)this.mMemoryCache.get((Object)key);
        if (val == null) {
            return defaultValue;
        }
        if (val.dueTime == -1L || val.dueTime >= System.currentTimeMillis()) {
            return (T)val.value;
        }
        this.mMemoryCache.remove((Object)key);
        return defaultValue;
    }

    public int getCacheCount() {
        return this.mMemoryCache.size();
    }

    public Object remove(@NonNull String key) {
        CacheValue remove = (CacheValue)this.mMemoryCache.remove((Object)key);
        if (remove == null) {
            return null;
        }
        return remove.value;
    }

    public void clear() {
        this.mMemoryCache.evictAll();
    }

    private static final class CacheValue {
        long dueTime;
        Object value;

        CacheValue(long dueTime, Object value) {
            this.dueTime = dueTime;
            this.value = value;
        }
    }
}

