/*
 * Decompiled with CFR 0.152.
 */
package io.github.dddplus.runtime.registry;

import io.github.dddplus.annotation.Specification;
import io.github.dddplus.runtime.registry.BootstrapException;
import io.github.dddplus.runtime.registry.IRegistryAware;
import io.github.dddplus.runtime.registry.InternalAopUtils;
import io.github.dddplus.runtime.registry.InternalIndexer;
import io.github.dddplus.specification.ISpecification;
import java.util.Arrays;
import javax.validation.constraints.NotNull;
import lombok.Generated;

class SpecificationDef
implements IRegistryAware {
    private String name;
    private String[] tags;
    private ISpecification specificationBean;

    SpecificationDef() {
    }

    @Override
    public void registerBean(@NotNull Object bean) {
        Specification specification = InternalAopUtils.getAnnotation(bean, Specification.class);
        this.name = specification.value();
        this.tags = specification.tags();
        if (!(bean instanceof ISpecification)) {
            throw BootstrapException.ofMessage(bean.getClass().getCanonicalName(), " MUST implement ISpecification");
        }
        this.specificationBean = (ISpecification)bean;
        InternalIndexer.index(this);
    }

    @Generated
    public String toString() {
        return "SpecificationDef(name=" + this.getName() + ", tags=" + Arrays.deepToString(this.getTags()) + ", specificationBean=" + this.getSpecificationBean() + ")";
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String[] getTags() {
        return this.tags;
    }

    @Generated
    public ISpecification getSpecificationBean() {
        return this.specificationBean;
    }
}

