/*
 * Decompiled with CFR 0.152.
 */
package io.github.dddplus.runtime.registry;

import io.github.dddplus.annotation.Partner;
import io.github.dddplus.ext.IDomainExtension;
import io.github.dddplus.ext.IIdentityResolver;
import io.github.dddplus.model.IDomainModel;
import io.github.dddplus.runtime.registry.BootstrapException;
import io.github.dddplus.runtime.registry.ExtensionDef;
import io.github.dddplus.runtime.registry.IPrepareAware;
import io.github.dddplus.runtime.registry.IRegistryAware;
import io.github.dddplus.runtime.registry.InternalAopUtils;
import io.github.dddplus.runtime.registry.InternalIndexer;
import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.NotNull;
import lombok.Generated;

class PartnerDef
implements IRegistryAware,
IPrepareAware,
IIdentityResolver {
    private String code;
    private String name;
    private IIdentityResolver partnerBean;
    private Map<Class<? extends IDomainExtension>, ExtensionDef> extensionDefMap = new HashMap<Class<? extends IDomainExtension>, ExtensionDef>();

    PartnerDef() {
    }

    @Override
    public void registerBean(@NotNull Object bean) {
        this.initialize(bean);
        InternalIndexer.index(this);
    }

    @Override
    public void prepare(@NotNull Object bean) {
        this.initialize(bean);
        InternalIndexer.prepare(this);
    }

    private void initialize(Object bean) {
        Partner partner = InternalAopUtils.getAnnotation(bean, Partner.class);
        this.code = partner.code();
        this.name = partner.name();
        if (!(bean instanceof IIdentityResolver)) {
            throw BootstrapException.ofMessage(bean.getClass().getCanonicalName(), " MUST implements IIdentityResolver");
        }
        this.partnerBean = (IIdentityResolver)bean;
    }

    void registerExtensionDef(ExtensionDef extensionDef) {
        Class<? extends IDomainExtension> extClazz = extensionDef.getExtClazz();
        if (this.extensionDefMap.containsKey(extClazz)) {
            throw BootstrapException.ofMessage("Partner(code=", this.code, ") can hold ONLY one instance on ", extClazz.getCanonicalName(), ", existing ", this.extensionDefMap.get(extClazz).toString(), ", illegal ", extensionDef.toString());
        }
        this.extensionDefMap.put(extClazz, extensionDef);
    }

    ExtensionDef getExtension(Class<? extends IDomainExtension> extClazz) {
        return this.extensionDefMap.get(extClazz);
    }

    public boolean match(@NotNull IDomainModel model) {
        return this.partnerBean.match(model);
    }

    @Generated
    public String toString() {
        return "PartnerDef(code=" + this.getCode() + ", name=" + this.getName() + ", partnerBean=" + this.getPartnerBean() + ", extensionDefMap=" + this.getExtensionDefMap() + ")";
    }

    @Generated
    public String getCode() {
        return this.code;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public IIdentityResolver getPartnerBean() {
        return this.partnerBean;
    }

    @Generated
    Map<Class<? extends IDomainExtension>, ExtensionDef> getExtensionDefMap() {
        return this.extensionDefMap;
    }
}

