/*
 * Decompiled with CFR 0.152.
 */
package io.github.dddplus.runtime;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

class NamedThreadFactory
implements ThreadFactory {
    static final AtomicInteger poolCount = new AtomicInteger(0);
    private final AtomicInteger threadCount = new AtomicInteger(1);
    private final ThreadGroup group;
    private final String namePrefix;
    private final boolean daemon;

    NamedThreadFactory(String prefix, boolean daemon) {
        SecurityManager s = System.getSecurityManager();
        this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
        this.namePrefix = prefix + "-" + poolCount.getAndIncrement() + "-T-";
        this.daemon = daemon;
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = new Thread(this.group, r, this.namePrefix + this.threadCount.getAndIncrement(), 0L);
        t.setDaemon(this.daemon);
        return t;
    }
}

