/*
 * Decompiled with CFR 0.152.
 */
package io.github.crow_misia.libyuv;

import android.graphics.Rect;
import io.github.crow_misia.libyuv.AbgrBuffer;
import io.github.crow_misia.libyuv.AbstractBuffer;
import io.github.crow_misia.libyuv.ArgbBuffer;
import io.github.crow_misia.libyuv.BufferExtKt;
import io.github.crow_misia.libyuv.BufferFactory;
import io.github.crow_misia.libyuv.BufferKt;
import io.github.crow_misia.libyuv.BufferX444;
import io.github.crow_misia.libyuv.Capacity;
import io.github.crow_misia.libyuv.CapacityCalculator;
import io.github.crow_misia.libyuv.FilterMode;
import io.github.crow_misia.libyuv.Plane;
import io.github.crow_misia.libyuv.Plane3Capacities;
import io.github.crow_misia.libyuv.PlanePrimitive;
import io.github.crow_misia.libyuv.RotateMode;
import io.github.crow_misia.libyuv.RowStride;
import io.github.crow_misia.libyuv.Yuv;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 %2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002:\u0001%BK\b\u0002\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\r\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0002\u0010\u0010J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001cJ2\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\nH\u0016\u00f8\u0001\u0000\u00a2\u0006\u0004\b#\u0010$R\u0014\u0010\u000b\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0007\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\b\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0012\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006&"}, d2={"Lio/github/crow_misia/libyuv/H444Buffer;", "Lio/github/crow_misia/libyuv/AbstractBuffer;", "Lio/github/crow_misia/libyuv/BufferX444;", "buffer", "Ljava/nio/ByteBuffer;", "planeY", "Lio/github/crow_misia/libyuv/Plane;", "planeU", "planeV", "width", "", "height", "cropRect", "Landroid/graphics/Rect;", "releaseCallback", "Ljava/lang/Runnable;", "(Ljava/nio/ByteBuffer;Lio/github/crow_misia/libyuv/Plane;Lio/github/crow_misia/libyuv/Plane;Lio/github/crow_misia/libyuv/Plane;IILandroid/graphics/Rect;Ljava/lang/Runnable;)V", "getHeight", "()I", "getPlaneU", "()Lio/github/crow_misia/libyuv/Plane;", "getPlaneV", "getPlaneY", "getWidth", "convertTo", "", "dst", "Lio/github/crow_misia/libyuv/AbgrBuffer;", "Lio/github/crow_misia/libyuv/ArgbBuffer;", "getPlaneOffset", "planeIndex", "rowStride", "Lio/github/crow_misia/libyuv/RowStride;", "left", "top", "getPlaneOffset-fuXAFhI", "(IIII)I", "Factory", "core_release"})
public final class H444Buffer
extends AbstractBuffer
implements BufferX444<H444Buffer> {
    @NotNull
    public static final Factory Factory = new Factory(null);
    @NotNull
    private final Plane planeY;
    @NotNull
    private final Plane planeU;
    @NotNull
    private final Plane planeV;
    private final int width;
    private final int height;

    private H444Buffer(ByteBuffer buffer, Plane planeY, Plane planeU, Plane planeV, int width, int height, Rect cropRect, Runnable releaseCallback) {
        Plane[] planeArray = new Plane[]{planeY, planeU, planeV};
        super(buffer, cropRect, planeArray, releaseCallback);
        this.planeY = planeY;
        this.planeU = planeU;
        this.planeV = planeV;
        this.width = width;
        this.height = height;
    }

    @Override
    @NotNull
    public Plane getPlaneY() {
        return this.planeY;
    }

    @Override
    @NotNull
    public Plane getPlaneU() {
        return this.planeU;
    }

    @Override
    @NotNull
    public Plane getPlaneV() {
        return this.planeV;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getPlaneOffset-fuXAFhI(int planeIndex, int rowStride, int left, int top) {
        return RowStride.times-impl(rowStride, top) + left;
    }

    @Override
    public final void convertTo(@NotNull ArgbBuffer dst) {
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        Pair<Integer, Integer> pair = BufferKt.calculateSize(this, dst);
        int fixedWidth = ((Number)pair.component1()).intValue();
        int fixedHeight = ((Number)pair.component2()).intValue();
        Yuv.INSTANCE.convertH444ToARGB(this.getPlaneY().getBuffer(), this.getPlaneY().getRowStride-BElzS_M(), BufferKt.offset(this, 0), this.getPlaneU().getBuffer(), this.getPlaneU().getRowStride-BElzS_M(), BufferKt.offset(this, 1), this.getPlaneV().getBuffer(), this.getPlaneV().getRowStride-BElzS_M(), BufferKt.offset(this, 2), dst.getPlane().getBuffer(), dst.getPlane().getRowStride-BElzS_M(), BufferKt.offset(dst, 0), fixedWidth, fixedHeight);
    }

    @Override
    public final void convertTo(@NotNull AbgrBuffer dst) {
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        Pair<Integer, Integer> pair = BufferKt.calculateSize(this, dst);
        int fixedWidth = ((Number)pair.component1()).intValue();
        int fixedHeight = ((Number)pair.component2()).intValue();
        Yuv.INSTANCE.convertH444ToABGR(this.getPlaneY().getBuffer(), this.getPlaneY().getRowStride-BElzS_M(), BufferKt.offset(this, 0), this.getPlaneU().getBuffer(), this.getPlaneU().getRowStride-BElzS_M(), BufferKt.offset(this, 1), this.getPlaneV().getBuffer(), this.getPlaneV().getRowStride-BElzS_M(), BufferKt.offset(this, 2), dst.getPlane().getBuffer(), dst.getPlane().getRowStride-BElzS_M(), BufferKt.offset(dst, 0), fixedWidth, fixedHeight);
    }

    @Override
    public void convertTo(@NotNull H444Buffer dst) {
        BufferX444.DefaultImpls.convertTo(this, (BufferX444)dst);
    }

    @Override
    public void rotate(@NotNull H444Buffer dst, @NotNull RotateMode rotateMode) {
        BufferX444.DefaultImpls.rotate(this, (BufferX444)dst, rotateMode);
    }

    @Override
    public void scale(@NotNull H444Buffer dst, @NotNull FilterMode filterMode) {
        BufferX444.DefaultImpls.scale(this, (BufferX444)dst, filterMode);
    }

    public /* synthetic */ H444Buffer(ByteBuffer buffer, Plane planeY, Plane planeU, Plane planeV, int width, int height, Rect cropRect, Runnable releaseCallback, DefaultConstructorMarker $constructor_marker) {
        this(buffer, planeY, planeU, planeV, width, height, cropRect, releaseCallback);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00040\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0005J \u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016J6\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bJ(\u0010\r\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\u0014"}, d2={"Lio/github/crow_misia/libyuv/H444Buffer$Factory;", "Lio/github/crow_misia/libyuv/BufferFactory;", "Lio/github/crow_misia/libyuv/H444Buffer;", "Lio/github/crow_misia/libyuv/CapacityCalculator;", "Lio/github/crow_misia/libyuv/Plane3Capacities;", "()V", "allocate", "width", "", "height", "cropRect", "Landroid/graphics/Rect;", "calculate", "wrap", "planeY", "Lio/github/crow_misia/libyuv/Plane;", "planeU", "planeV", "buffer", "Ljava/nio/ByteBuffer;", "core_release"})
    @SourceDebugExtension(value={"SMAP\nH444Buffer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 H444Buffer.kt\nio/github/crow_misia/libyuv/H444Buffer$Factory\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,105:1\n1#2:106\n*E\n"})
    public static final class Factory
    implements BufferFactory<H444Buffer>,
    CapacityCalculator<Plane3Capacities> {
        private Factory() {
        }

        @Override
        @NotNull
        public Plane3Capacities calculate(int width, int height) {
            int capacity = width * height;
            int n = RowStride.constructor-impl(width);
            int n2 = RowStride.constructor-impl(width);
            int n3 = RowStride.constructor-impl(width);
            int n4 = Capacity.constructor-impl(capacity);
            int n5 = Capacity.constructor-impl(capacity);
            int n6 = Capacity.constructor-impl(capacity);
            return new Plane3Capacities(n4, n5, n6, n, n2, n3, null);
        }

        @Override
        @NotNull
        public H444Buffer allocate(int width, int height, @NotNull Rect cropRect) {
            Intrinsics.checkNotNullParameter((Object)cropRect, (String)"cropRect");
            Plane3Capacities plane3Capacities = this.calculate(width, height);
            int capacityY = plane3Capacities.component1-v5S6rBc();
            int capacityU = plane3Capacities.component2-v5S6rBc();
            int capacityV = plane3Capacities.component3-v5S6rBc();
            int strideY = plane3Capacities.component4-BElzS_M();
            int strideU = plane3Capacities.component5-BElzS_M();
            int strideV = plane3Capacities.component6-BElzS_M();
            Object[] objectArray = new Capacity[]{Capacity.box-impl(capacityY), Capacity.box-impl(capacityU), Capacity.box-impl(capacityV)};
            ByteBuffer[] byteBufferArray = BufferExtKt.createByteBuffer(CollectionsKt.listOf((Object[])objectArray));
            ByteBuffer bufferY = byteBufferArray[0];
            ByteBuffer bufferU = byteBufferArray[1];
            ByteBuffer bufferV = byteBufferArray[2];
            ByteBuffer buffer = byteBufferArray[3];
            return new H444Buffer(buffer, new PlanePrimitive(strideY, bufferY, null), new PlanePrimitive(strideU, bufferU, null), new PlanePrimitive(strideV, bufferV, null), width, height, cropRect, () -> Factory.allocate$lambda$0(buffer), null);
        }

        @Override
        @NotNull
        public H444Buffer wrap(@NotNull ByteBuffer buffer, int width, int height, @NotNull Rect cropRect) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            Intrinsics.checkNotNullParameter((Object)cropRect, (String)"cropRect");
            if (!buffer.isDirect()) {
                boolean $i$a$-check-H444Buffer$Factory$wrap$22 = false;
                String $i$a$-check-H444Buffer$Factory$wrap$22 = "Unsupported non-direct ByteBuffer.";
                throw new IllegalStateException($i$a$-check-H444Buffer$Factory$wrap$22.toString());
            }
            Plane3Capacities plane3Capacities = this.calculate(width, height);
            int capacityY = plane3Capacities.component1-v5S6rBc();
            int capacityU = plane3Capacities.component2-v5S6rBc();
            int capacityV = plane3Capacities.component3-v5S6rBc();
            int strideY = plane3Capacities.component4-BElzS_M();
            int strideU = plane3Capacities.component5-BElzS_M();
            int strideV = plane3Capacities.component6-BElzS_M();
            Object[] objectArray = new Capacity[]{Capacity.box-impl(capacityY), Capacity.box-impl(capacityU), Capacity.box-impl(capacityV)};
            ByteBuffer[] byteBufferArray = BufferExtKt.sliceByLength(buffer, CollectionsKt.listOf((Object[])objectArray));
            ByteBuffer bufferY = byteBufferArray[0];
            ByteBuffer bufferU = byteBufferArray[1];
            ByteBuffer bufferV = byteBufferArray[2];
            return new H444Buffer(buffer, new PlanePrimitive(strideY, bufferY, null), new PlanePrimitive(strideU, bufferU, null), new PlanePrimitive(strideV, bufferV, null), width, height, cropRect, null, null);
        }

        @NotNull
        public final H444Buffer wrap(@NotNull Plane planeY, @NotNull Plane planeU, @NotNull Plane planeV, int width, int height, @NotNull Rect cropRect) {
            Intrinsics.checkNotNullParameter((Object)planeY, (String)"planeY");
            Intrinsics.checkNotNullParameter((Object)planeU, (String)"planeU");
            Intrinsics.checkNotNullParameter((Object)planeV, (String)"planeV");
            Intrinsics.checkNotNullParameter((Object)cropRect, (String)"cropRect");
            return new H444Buffer(null, planeY, planeU, planeV, width, height, cropRect, null, null);
        }

        @Override
        @NotNull
        public H444Buffer allocate(int width, int height) {
            return BufferFactory.DefaultImpls.allocate(this, width, height);
        }

        @Override
        @NotNull
        public H444Buffer wrap(@NotNull ByteBuffer buffer, int width, int height) {
            return BufferFactory.DefaultImpls.wrap(this, buffer, width, height);
        }

        private static final void allocate$lambda$0(ByteBuffer $buffer) {
            Intrinsics.checkNotNullParameter((Object)$buffer, (String)"$buffer");
            Yuv.INSTANCE.freeNativeBuffer($buffer);
        }

        public /* synthetic */ Factory(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

