/*
 * Decompiled with CFR 0.152.
 */
package io.github.crow_misia.libyuv;

import io.github.crow_misia.libyuv.AbgrBuffer;
import io.github.crow_misia.libyuv.AbstractBuffer;
import io.github.crow_misia.libyuv.ArgbBuffer;
import io.github.crow_misia.libyuv.BufferExtKt;
import io.github.crow_misia.libyuv.BufferFactory;
import io.github.crow_misia.libyuv.BufferX422;
import io.github.crow_misia.libyuv.FilterMode;
import io.github.crow_misia.libyuv.Plane;
import io.github.crow_misia.libyuv.PlanePrimitive;
import io.github.crow_misia.libyuv.RotateMode;
import io.github.crow_misia.libyuv.Yuv;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001b2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002:\u0001\u001bBC\b\u0002\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eJ\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u001aR\u0014\u0010\u000b\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0007\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\b\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lio/github/crow_misia/libyuv/H422Buffer;", "Lio/github/crow_misia/libyuv/AbstractBuffer;", "Lio/github/crow_misia/libyuv/BufferX422;", "buffer", "Ljava/nio/ByteBuffer;", "planeY", "Lio/github/crow_misia/libyuv/Plane;", "planeU", "planeV", "width", "", "height", "releaseCallback", "Ljava/lang/Runnable;", "(Ljava/nio/ByteBuffer;Lio/github/crow_misia/libyuv/Plane;Lio/github/crow_misia/libyuv/Plane;Lio/github/crow_misia/libyuv/Plane;IILjava/lang/Runnable;)V", "getHeight", "()I", "getPlaneU", "()Lio/github/crow_misia/libyuv/Plane;", "getPlaneV", "getPlaneY", "getWidth", "convertTo", "", "dst", "Lio/github/crow_misia/libyuv/AbgrBuffer;", "Lio/github/crow_misia/libyuv/ArgbBuffer;", "Factory", "core_release"})
public final class H422Buffer
extends AbstractBuffer
implements BufferX422<H422Buffer> {
    @NotNull
    public static final Factory Factory = new Factory(null);
    @NotNull
    private final Plane planeY;
    @NotNull
    private final Plane planeU;
    @NotNull
    private final Plane planeV;
    private final int width;
    private final int height;

    private H422Buffer(ByteBuffer buffer, Plane planeY, Plane planeU, Plane planeV, int width, int height, Runnable releaseCallback) {
        Plane[] planeArray = new Plane[]{planeY, planeU, planeV};
        super(buffer, planeArray, releaseCallback);
        this.planeY = planeY;
        this.planeU = planeU;
        this.planeV = planeV;
        this.width = width;
        this.height = height;
    }

    @Override
    @NotNull
    public Plane getPlaneY() {
        return this.planeY;
    }

    @Override
    @NotNull
    public Plane getPlaneU() {
        return this.planeU;
    }

    @Override
    @NotNull
    public Plane getPlaneV() {
        return this.planeV;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public final void convertTo(@NotNull ArgbBuffer dst) {
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        Yuv.INSTANCE.convertH422ToARGB(this.getPlaneY().getBuffer(), this.getPlaneY().getRowStride(), this.getPlaneU().getBuffer(), this.getPlaneU().getRowStride(), this.getPlaneV().getBuffer(), this.getPlaneV().getRowStride(), dst.getPlane().getBuffer(), dst.getPlane().getRowStride(), Math.min(this.getWidth(), dst.getWidth()), Math.min(this.getHeight(), dst.getHeight()));
    }

    @Override
    public final void convertTo(@NotNull AbgrBuffer dst) {
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        Yuv.INSTANCE.convertH422ToABGR(this.getPlaneY().getBuffer(), this.getPlaneY().getRowStride(), this.getPlaneU().getBuffer(), this.getPlaneU().getRowStride(), this.getPlaneV().getBuffer(), this.getPlaneV().getRowStride(), dst.getPlane().getBuffer(), dst.getPlane().getRowStride(), Math.min(this.getWidth(), dst.getWidth()), Math.min(this.getHeight(), dst.getHeight()));
    }

    @Override
    public void convertTo(@NotNull H422Buffer dst) {
        BufferX422.DefaultImpls.convertTo(this, (BufferX422)dst);
    }

    @Override
    public void rotate(@NotNull H422Buffer dst, @NotNull RotateMode rotateMode) {
        BufferX422.DefaultImpls.rotate(this, (BufferX422)dst, rotateMode);
    }

    @Override
    public void scale(@NotNull H422Buffer dst, @NotNull FilterMode filterMode) {
        BufferX422.DefaultImpls.scale(this, (BufferX422)dst, filterMode);
    }

    public /* synthetic */ H422Buffer(ByteBuffer buffer, Plane planeY, Plane planeU, Plane planeV, int width, int height, Runnable releaseCallback, DefaultConstructorMarker $constructor_marker) {
        this(buffer, planeY, planeU, planeV, width, height, releaseCallback);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002J.\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006J \u0010\n\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a8\u0006\u0011"}, d2={"Lio/github/crow_misia/libyuv/H422Buffer$Factory;", "Lio/github/crow_misia/libyuv/BufferFactory;", "Lio/github/crow_misia/libyuv/H422Buffer;", "()V", "allocate", "width", "", "height", "getStrideWithCapacity", "", "wrap", "planeY", "Lio/github/crow_misia/libyuv/Plane;", "planeU", "planeV", "buffer", "Ljava/nio/ByteBuffer;", "core_release"})
    @SourceDebugExtension(value={"SMAP\nH422Buffer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 H422Buffer.kt\nio/github/crow_misia/libyuv/H422Buffer$Factory\n+ 2 BufferExt.kt\nio/github/crow_misia/libyuv/BufferExtKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,91:1\n64#2:92\n64#2:94\n1#3:93\n*S KotlinDebug\n*F\n+ 1 H422Buffer.kt\nio/github/crow_misia/libyuv/H422Buffer$Factory\n*L\n47#1:92\n65#1:94\n*E\n"})
    public static final class Factory
    implements BufferFactory<H422Buffer> {
        private Factory() {
        }

        private final int[] getStrideWithCapacity(int width, int height) {
            int halfWidth = width + 1 >> 1;
            int capacity = width * height;
            int halfCapacity = (halfWidth + 1 >> 1) * height;
            int[] nArray = new int[]{width, capacity, halfWidth, halfCapacity, halfWidth, halfCapacity};
            return nArray;
        }

        @Override
        @NotNull
        public H422Buffer allocate(int width, int height) {
            int[] nArray = this.getStrideWithCapacity(width, height);
            int strideY = nArray[0];
            int capacityY = nArray[1];
            int strideU = nArray[2];
            int capacityU = nArray[3];
            int strideV = nArray[4];
            int[] $this$component6$iv = nArray;
            boolean $i$f$component6 = false;
            int capacityV = $this$component6$iv[5];
            ByteBuffer buffer = BufferExtKt.createByteBuffer(capacityY + capacityU + capacityV);
            int[] nArray2 = new int[]{capacityY, capacityU, capacityV};
            ByteBuffer[] byteBufferArray = BufferExtKt.slice(buffer, nArray2);
            ByteBuffer bufferY = byteBufferArray[0];
            ByteBuffer bufferU = byteBufferArray[1];
            ByteBuffer bufferV = byteBufferArray[2];
            return new H422Buffer(buffer, new PlanePrimitive(strideY, bufferY), new PlanePrimitive(strideU, bufferU), new PlanePrimitive(strideV, bufferV), width, height, () -> Factory.allocate$lambda$0(buffer), null);
        }

        @Override
        @NotNull
        public H422Buffer wrap(@NotNull ByteBuffer buffer, int width, int height) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            if (!buffer.isDirect()) {
                boolean $i$a$-check-H422Buffer$Factory$wrap$22 = false;
                String $i$a$-check-H422Buffer$Factory$wrap$22 = "Unsupported non-direct ByteBuffer.";
                throw new IllegalStateException($i$a$-check-H422Buffer$Factory$wrap$22.toString());
            }
            int[] nArray = this.getStrideWithCapacity(width, height);
            int strideY = nArray[0];
            int capacityY = nArray[1];
            int strideU = nArray[2];
            int capacityU = nArray[3];
            int strideV = nArray[4];
            int[] $this$component6$iv = nArray;
            boolean $i$f$component72 = false;
            int capacityV = $this$component6$iv[5];
            int[] $i$f$component72 = new int[]{capacityY, capacityU, capacityV};
            ByteBuffer[] byteBufferArray = BufferExtKt.slice(buffer, $i$f$component72);
            ByteBuffer bufferY = byteBufferArray[0];
            ByteBuffer bufferU = byteBufferArray[1];
            ByteBuffer bufferV = byteBufferArray[2];
            return new H422Buffer(buffer, new PlanePrimitive(strideY, bufferY), new PlanePrimitive(strideU, bufferU), new PlanePrimitive(strideV, bufferV), width, height, null, null);
        }

        @NotNull
        public final H422Buffer wrap(@NotNull Plane planeY, @NotNull Plane planeU, @NotNull Plane planeV, int width, int height) {
            Intrinsics.checkNotNullParameter((Object)planeY, (String)"planeY");
            Intrinsics.checkNotNullParameter((Object)planeU, (String)"planeU");
            Intrinsics.checkNotNullParameter((Object)planeV, (String)"planeV");
            return new H422Buffer(null, planeY, planeU, planeV, width, height, null, null);
        }

        private static final void allocate$lambda$0(ByteBuffer $buffer) {
            Intrinsics.checkNotNullParameter((Object)$buffer, (String)"$buffer");
            Yuv.INSTANCE.freeNativeBuffer($buffer);
        }

        public /* synthetic */ Factory(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

