/*
 * Decompiled with CFR 0.152.
 */
package io.github.crimix.changedprojectstask.providers;

import io.github.crimix.changedprojectstask.extensions.Extensions;
import io.github.crimix.changedprojectstask.utils.GitDiffMode;
import java.util.Optional;
import org.gradle.api.Project;
import org.gradle.internal.impldep.org.jetbrains.annotations.VisibleForTesting;

public class GitCommandProvider {
    private static final String HEAD = "HEAD";
    private static final String BASE_DIFF_COMMAND = "git diff --name-only";
    private final Project project;

    public GitCommandProvider(Project project) {
        this.project = project;
    }

    public String getGitDiffCommand() {
        GitDiffMode mode = Extensions.getCommitCompareMode(this.project);
        Optional<String> currentCommitId = Extensions.getCommitId(this.project);
        Optional<String> previousCommitId = Extensions.getPreviousCommitId(this.project);
        return this.evaluate(mode, currentCommitId, previousCommitId);
    }

    @VisibleForTesting
    public String evaluate(GitDiffMode mode, Optional<String> currentCommitId, Optional<String> previousCommitId) {
        switch (mode) {
            case COMMIT: {
                return this.getCommitDiff(currentCommitId, previousCommitId);
            }
            case BRANCH: {
                return this.getBranchDiff(currentCommitId, previousCommitId);
            }
            case BRANCH_TWO_DOT: {
                return this.getBranchTwoDotDiff(currentCommitId, previousCommitId);
            }
            case BRANCH_THREE_DOT: {
                return this.getBranchThreeDotDiff(currentCommitId, previousCommitId);
            }
        }
        throw new UnsupportedOperationException(String.format("GitCommitMode %s is not supported", mode.name()));
    }

    private String getCommitDiff(Optional<String> currentCommitId, Optional<String> previousCommitId) {
        if (currentCommitId.isPresent() && previousCommitId.isPresent()) {
            return String.format("%s %s~ %s", BASE_DIFF_COMMAND, previousCommitId.get(), currentCommitId.get());
        }
        if (currentCommitId.isPresent()) {
            return String.format("%s %s~ %s", BASE_DIFF_COMMAND, currentCommitId.get(), currentCommitId.get());
        }
        if (previousCommitId.isPresent()) {
            throw new IllegalStateException(String.format("[%s] When using %s then %s must also be specified", GitDiffMode.COMMIT.name(), "changedProjectsTask.prevCommit", "changedProjectsTask.commit"));
        }
        return String.format("%s %s~ %s", BASE_DIFF_COMMAND, HEAD, HEAD);
    }

    private String getBranchDiff(Optional<String> currentCommitId, Optional<String> previousCommitId) {
        if (currentCommitId.isPresent() && previousCommitId.isPresent()) {
            return String.format("%s %s %s", BASE_DIFF_COMMAND, previousCommitId.get(), currentCommitId.get());
        }
        if (previousCommitId.isPresent()) {
            return String.format("%s %s %s", BASE_DIFF_COMMAND, previousCommitId.get(), HEAD);
        }
        throw new IllegalStateException(String.format("[%s] %s must always be specified", GitDiffMode.BRANCH.name(), "changedProjectsTask.prevCommit"));
    }

    private String getBranchTwoDotDiff(Optional<String> currentCommitId, Optional<String> previousCommitId) {
        if (currentCommitId.isPresent() && previousCommitId.isPresent()) {
            return String.format("%s %s..%s", BASE_DIFF_COMMAND, previousCommitId.get(), currentCommitId.get());
        }
        if (previousCommitId.isPresent()) {
            return String.format("%s %s..", BASE_DIFF_COMMAND, previousCommitId.get());
        }
        throw new IllegalStateException(String.format("[%s] %s must always be specified", GitDiffMode.BRANCH_TWO_DOT.name(), "changedProjectsTask.prevCommit"));
    }

    private String getBranchThreeDotDiff(Optional<String> currentCommitId, Optional<String> previousCommitId) {
        if (currentCommitId.isPresent() && previousCommitId.isPresent()) {
            return String.format("%s %s...%s", BASE_DIFF_COMMAND, previousCommitId.get(), currentCommitId.get());
        }
        if (previousCommitId.isPresent()) {
            return String.format("%s %s...", BASE_DIFF_COMMAND, previousCommitId.get());
        }
        throw new IllegalStateException(String.format("[%s] %s must always be specified", GitDiffMode.BRANCH_THREE_DOT.name(), "changedProjectsTask.prevCommit"));
    }
}

