/*
 * Decompiled with CFR 0.152.
 */
package io.github.changebooks.worksheet;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class Utf8Utils {
    public static final int BUCKET_SIZE = 1024;
    public static final int BYTE_SIZE = 8;
    private final int checkSize;

    public Utf8Utils() {
        this.checkSize = 0;
    }

    public Utf8Utils(int checkSize) {
        Preconditions.checkArgument((checkSize >= 0 ? 1 : 0) != 0, (Object)"checkSize must be non-negative");
        this.checkSize = checkSize;
    }

    public boolean check(File file) throws IOException {
        Preconditions.checkNotNull((Object)file, (Object)"file can't be null");
        return Utf8Utils.checkHead(file) || Utf8Utils.checkBody(file, this.checkSize);
    }

    public int getCheckSize() {
        return this.checkSize;
    }

    public static boolean checkHead(File file) throws IOException {
        Preconditions.checkNotNull((Object)file, (Object)"file can't be null");
        try (FileInputStream stream = new FileInputStream(file);){
            boolean bl = Utf8Utils.checkHead(stream);
            return bl;
        }
    }

    public static boolean checkHead(InputStream stream) throws IOException {
        Preconditions.checkNotNull((Object)stream, (Object)"stream can't be null");
        byte[] head = new byte[3];
        int size = stream.read(head);
        if (size < 3) {
            return false;
        }
        if (head[0] == -1 && head[1] == -2) {
            return true;
        }
        if (head[0] == -2 && head[1] == -1) {
            return true;
        }
        return head[0] == -17 && head[1] == -69 && head[2] == -65;
    }

    public static boolean checkBody(File file, int checkSize) throws IOException {
        Preconditions.checkNotNull((Object)file, (Object)"file can't be null");
        Preconditions.checkArgument((checkSize >= 0 ? 1 : 0) != 0, (Object)"checkSize must be non-negative");
        try (FileInputStream stream = new FileInputStream(file);){
            boolean bl = Utf8Utils.checkBody(stream, checkSize);
            return bl;
        }
    }

    public static boolean checkBody(InputStream stream, int checkSize) throws IOException {
        Preconditions.checkNotNull((Object)stream, (Object)"stream can't be null");
        Preconditions.checkArgument((checkSize >= 0 ? 1 : 0) != 0, (Object)"checkSize must be non-negative");
        byte[] data = Utf8Utils.read(stream, checkSize);
        return Utf8Utils.check(data);
    }

    public static boolean check(byte[] data) {
        Preconditions.checkNotNull((Object)data, (Object)"data can't be null");
        int len = data.length;
        Preconditions.checkArgument((len > 0 ? 1 : 0) != 0, (Object)"data.len must be positive");
        for (int i = 0; i < len; ++i) {
            byte value = data[i];
            if (Utf8Utils.isSingle(value)) continue;
            int size = MultiByte.size(value) - 1;
            if (size < 1) {
                return false;
            }
            int index = i + 1;
            if (!MultiByte.checkSlice(data, index, size)) {
                return false;
            }
            i += size;
        }
        return true;
    }

    public static boolean checkBit(byte value, int index) {
        if (index < 0 || index >= 8) {
            return false;
        }
        int offset = 8 - index - 1;
        return (1 & value >> offset) == 1;
    }

    public static boolean isSingle(byte value) {
        return !Utf8Utils.checkBit(value, 0);
    }

    public static boolean isMulti(byte value) {
        return Utf8Utils.checkBit(value, 0);
    }

    /*
     * Exception decompiling
     */
    public static byte[] read(InputStream stream, int size) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static final class MultiByte {
        public static boolean checkSlice(byte[] data, int index, int size) {
            Preconditions.checkNotNull((Object)data, (Object)"data can't be null");
            int len = data.length;
            Preconditions.checkArgument((index < len ? 1 : 0) != 0, (Object)String.format("index out of data.len, index: %d, data.len: %d", index, len));
            int i = index;
            for (int j = 0; i < len && j < size; ++i, ++j) {
                if (MultiByte.checkByte(data[i])) continue;
                return false;
            }
            return true;
        }

        public static boolean checkByte(byte value) {
            return Utf8Utils.checkBit(value, 0) && !Utf8Utils.checkBit(value, 1);
        }

        public static int size(byte first) {
            int result = 0;
            for (int i = 0; i < 8 && Utf8Utils.checkBit(first, i); ++i) {
                ++result;
            }
            return result;
        }
    }
}

