/*
 * Decompiled with CFR 0.152.
 */
package io.github.changebooks.worksheet;

import com.google.common.base.Preconditions;
import com.opencsv.CSVReader;
import com.opencsv.CSVReaderBuilder;
import com.opencsv.ICSVParser;
import com.opencsv.RFC4180Parser;
import com.opencsv.RFC4180ParserBuilder;
import com.opencsv.exceptions.CsvValidationException;
import io.github.changebooks.worksheet.ReadLine;
import io.github.changebooks.worksheet.ReadPage;
import io.github.changebooks.worksheet.ReadUtils;
import io.github.changebooks.worksheet.StopException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReadCsv {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReadCsv.class);
    private static final RFC4180Parser RFC4180_PARSER = new RFC4180ParserBuilder().build();
    private final int pageSize;

    public static ReadCsv create(int pageSize) {
        return new ReadCsv(pageSize);
    }

    private ReadCsv(int pageSize) {
        Preconditions.checkArgument((pageSize > 0 ? 1 : 0) != 0, (Object)"pageSize must be positive");
        this.pageSize = pageSize;
    }

    public void readPage(File file, Charset charset, ReadPage.Listener listener) throws IOException {
        Preconditions.checkNotNull((Object)file, (Object)"file can't be null");
        try (FileInputStream stream = new FileInputStream(file);){
            this.readPage(stream, charset, listener);
        }
    }

    public void readPage(InputStream stream, Charset charset, final ReadPage.Listener listener) throws IOException {
        Preconditions.checkNotNull((Object)listener, (Object)"listener can't be null");
        final Integer[] startRow = new Integer[]{null};
        final ArrayList<Map<String, String>> data = new ArrayList<Map<String, String>>();
        ReadCsv.readLine(stream, charset, new ReadLine.Listener(){

            @Override
            public void invoke(Integer rowIndex, Map<String, String> valueMap) {
                if (Objects.isNull(startRow[0])) {
                    startRow[0] = rowIndex;
                }
                if (data.size() < ReadCsv.this.pageSize) {
                    data.add(valueMap);
                }
                if (data.size() >= ReadCsv.this.pageSize) {
                    listener.invoke(startRow[0], data);
                    startRow[0] = null;
                    data.clear();
                }
            }

            @Override
            public void onComplete(Integer rowIndex) {
            }
        });
        if (data.size() > 0) {
            listener.invoke(startRow[0], data);
            data.clear();
        }
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public static List<Map<String, String>> readSync(File file, Charset charset) throws IOException {
        Preconditions.checkNotNull((Object)file, (Object)"file can't be null");
        try (FileInputStream stream = new FileInputStream(file);){
            List<Map<String, String>> list = ReadCsv.readSync(stream, charset);
            return list;
        }
    }

    public static List<Map<String, String>> readSync(InputStream stream, Charset charset) throws IOException {
        final ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        ReadCsv.readLine(stream, charset, new ReadLine.Listener(){

            @Override
            public void invoke(Integer rowIndex, Map<String, String> valueMap) {
                if (Objects.isNull(valueMap)) {
                    LOGGER.error("read null, skip rowIndex: " + rowIndex);
                } else {
                    result.add(valueMap);
                }
            }

            @Override
            public void onComplete(Integer rowIndex) {
            }
        });
        return result;
    }

    public static void readLine(File file, Charset charset, ReadLine.Listener listener) throws IOException {
        Preconditions.checkNotNull((Object)file, (Object)"file can't be null");
        try (FileInputStream stream = new FileInputStream(file);){
            ReadCsv.readLine(stream, charset, listener);
        }
    }

    public static void readLine(InputStream stream, Charset charset, ReadLine.Listener listener) throws IOException {
        Preconditions.checkNotNull((Object)stream, (Object)"stream can't be null");
        Preconditions.checkNotNull((Object)listener, (Object)"listener can't be null");
        try (InputStreamReader reader = Objects.isNull(charset) ? new InputStreamReader(stream) : new InputStreamReader(stream, charset);){
            ReadCsv.readLine(reader, listener);
        }
    }

    public static void readLine(InputStreamReader stream, final ReadLine.Listener listener) throws IOException {
        Preconditions.checkNotNull((Object)stream, (Object)"stream can't be null");
        Preconditions.checkNotNull((Object)listener, (Object)"listener can't be null");
        CSVReaderBuilder builder = new CSVReaderBuilder((Reader)stream).withCSVParser((ICSVParser)RFC4180_PARSER);
        try (CSVReader reader = builder.build();){
            ReadCsv.readLine(reader, new Listener(){
                private Map<Integer, String> keys;

                @Override
                public void invokeKey(Map<Integer, String> keyMap) {
                    this.keys = ReadUtils.asKey(keyMap);
                }

                @Override
                public void invokeValue(int rowIndex, Map<Integer, String> valueMap) {
                    Map<String, String> data = ReadUtils.combine(this.keys, valueMap);
                    listener.invoke(rowIndex, data);
                }

                @Override
                public void onComplete(int rowIndex) {
                    listener.onComplete(rowIndex);
                }
            });
        }
    }

    public static void readLine(CSVReader reader, Listener listener) throws IOException {
        Preconditions.checkNotNull((Object)reader, (Object)"reader can't be null");
        Preconditions.checkNotNull((Object)listener, (Object)"listener can't be null");
        int rowIndex = 0;
        while (true) {
            String[] bucket;
            try {
                bucket = reader.readNext();
                if (bucket == null) {
                    listener.onComplete(rowIndex - 1);
                    break;
                }
            }
            catch (CsvValidationException e) {
                LOGGER.error("readLine failed, rowIndex: {}, throwable: ", (Object)rowIndex, (Object)e);
                bucket = null;
            }
            Map<Integer, String> valueMap = ReadUtils.asMap(bucket);
            if (rowIndex++ == 0) {
                listener.invokeKey(valueMap);
                continue;
            }
            try {
                listener.invokeValue(rowIndex - 1, valueMap);
            }
            catch (StopException e) {
                break;
            }
        }
    }

    public static interface Listener {
        public void invokeKey(Map<Integer, String> var1);

        public void invokeValue(int var1, Map<Integer, String> var2);

        public void onComplete(int var1);
    }
}

