/*
 * Decompiled with CFR 0.152.
 */
package io.github.cgi.zabbix.api;

import io.github.cgi.zabbix.api.Request;
import java.util.concurrent.atomic.AtomicInteger;

public class RequestBuilder {
    private static final AtomicInteger nextId = new AtomicInteger(1);
    private Request request = new Request();

    private RequestBuilder() {
    }

    public static RequestBuilder newBuilder() {
        return new RequestBuilder();
    }

    public Request build() {
        if (this.request.getId() == null) {
            this.request.setId(nextId.getAndIncrement());
        }
        return this.request;
    }

    public RequestBuilder version(String version) {
        this.request.setJsonrpc(version);
        return this;
    }

    public RequestBuilder paramEntry(String key, Object value) {
        this.request.putParam(key, value);
        return this;
    }

    public RequestBuilder auth(String auth) {
        this.request.setAuth(auth);
        return this;
    }

    public RequestBuilder method(String method) {
        this.request.setMethod(method);
        return this;
    }

    public RequestBuilder id(Integer id) {
        this.request.setId(id);
        return this;
    }
}

