/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdiunit.spock.internal;

import io.github.cdiunit.internal.TestLifecycle;
import io.github.cdiunit.internal.TestMethodInvocationContext;
import java.lang.reflect.Method;
import org.spockframework.runtime.extension.IMethodInterceptor;
import org.spockframework.runtime.extension.IMethodInvocation;
import org.spockframework.runtime.extension.IStore;

public class InvokeBoundInterceptors
implements IMethodInterceptor {
    private final IStore.Namespace namespace;

    public InvokeBoundInterceptors(IStore.Namespace namespace) {
        this.namespace = namespace;
    }

    public void intercept(IMethodInvocation invocation) throws Throwable {
        IStore store = invocation.getStore(this.namespace);
        TestLifecycle testLifecycle = (TestLifecycle)store.get((Object)invocation, TestLifecycle.class);
        if (testLifecycle == null) {
            throw new IllegalStateException(String.format("no test lifecycle bound to %s", invocation));
        }
        Method method = testLifecycle.getTestMethod();
        if (method == null) {
            invocation.proceed();
            return;
        }
        Object target = invocation.getInstance();
        Object[] parameters = invocation.getArguments();
        TestMethodInvocationContext methodInvocationContext = new TestMethodInvocationContext(target, method, parameters, () -> ((IMethodInvocation)invocation).proceed());
        methodInvocationContext.resolveInterceptors(testLifecycle.getBeanManager());
        methodInvocationContext.proceed();
    }
}

