/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdiunit.junit5.internal;

import io.github.cdiunit.internal.TestLifecycle;
import io.github.cdiunit.internal.TestMethodInvocationContext;
import java.lang.reflect.Method;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.jupiter.api.extension.ReflectiveInvocationContext;

public class InvokeInterceptors
implements InvocationInterceptor.Invocation<Void> {
    private final InvocationInterceptor.Invocation<Void> next;
    private final ReflectiveInvocationContext<Method> invocationContext;
    private final TestLifecycle testLifecycle;
    private TestMethodInvocationContext<Object> methodInvocationContext;

    public InvokeInterceptors(InvocationInterceptor.Invocation<Void> next, ReflectiveInvocationContext<Method> invocationContext, TestLifecycle testLifecycle) {
        this.next = next;
        this.invocationContext = invocationContext;
        this.testLifecycle = testLifecycle;
    }

    public Void proceed() throws Exception {
        if (this.methodInvocationContext == null) {
            Object target = this.invocationContext.getTarget().orElseThrow(() -> new IllegalStateException("target instance is required"));
            Method method = (Method)this.invocationContext.getExecutable();
            Object[] parameters = this.invocationContext.getArguments().toArray();
            this.methodInvocationContext = new TestMethodInvocationContext(target, method, parameters, () -> this.next.proceed());
            this.methodInvocationContext.resolveInterceptors(this.testLifecycle.getBeanManager());
        }
        this.methodInvocationContext.proceed();
        return null;
    }
}

