/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdiunit.junit4.internal;

import io.github.cdiunit.IsolationLevel;
import io.github.cdiunit.internal.TestLifecycle;
import io.github.cdiunit.internal.activatescopes.ScopesHelper;
import jakarta.enterprise.inject.spi.BeanManager;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.runners.model.Statement;

public class ActivateScopes
extends Statement {
    private final Statement next;
    private final TestLifecycle testLifecycle;
    private final AtomicBoolean contextsActivated;

    public ActivateScopes(Statement next, TestLifecycle testLifecycle, AtomicBoolean contextsActivated) {
        this.next = next;
        this.testLifecycle = testLifecycle;
        this.contextsActivated = contextsActivated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evaluate() throws Throwable {
        Method method = this.testLifecycle.getTestMethod();
        IsolationLevel isolationLevel = this.testLifecycle.getIsolationLevel();
        BeanManager beanManager = this.testLifecycle.getBeanManager();
        try {
            if (!this.contextsActivated.get()) {
                ScopesHelper.activateContexts(beanManager, method);
                this.contextsActivated.set(true);
            }
            this.next.evaluate();
        }
        finally {
            if (this.contextsActivated.get() && isolationLevel == IsolationLevel.PER_METHOD) {
                this.contextsActivated.set(false);
                ScopesHelper.deactivateContexts(beanManager, method);
            }
        }
    }
}

