/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdiunit.internal.servlet;

import io.github.cdiunit.internal.ClassLookup;
import io.github.cdiunit.internal.DiscoveryExtension;
import io.github.cdiunit.internal.servlet.CdiUnitInitialListenerImpl;
import io.github.cdiunit.internal.servlet.InConversationInterceptor;
import io.github.cdiunit.internal.servlet.InRequestInterceptor;
import io.github.cdiunit.internal.servlet.InSessionInterceptor;
import io.github.cdiunit.internal.servlet.ServletObjectsProducer;
import io.github.cdiunit.servlet5.ServletAPI5Mocks;
import io.github.cdiunit.servlet6.ServletAPI6Mocks;
import java.lang.reflect.Type;

public class ServletDiscoveryExtension
implements DiscoveryExtension {
    private final boolean usesServlet = ClassLookup.INSTANCE.isPresent("jakarta.servlet.http.HttpServletRequest");
    private final boolean servletApi5 = ClassLookup.INSTANCE.isPresent("jakarta.servlet.http.HttpSessionContext");
    private final boolean requiresServletObjectsProducers = !ClassLookup.INSTANCE.isPresent("org.jboss.weld.bean.AbstractSyntheticBean");

    @Override
    public void bootstrap(DiscoveryExtension.BootstrapDiscoveryContext bdc) {
        if (this.usesServlet) {
            bdc.discoverExtension(this::discoverCdiExtension);
            if (this.requiresServletObjectsProducers) {
                bdc.discoverExtension(this::discoverServletObjectsProducers);
            }
        }
    }

    private void discoverCdiExtension(DiscoveryExtension.Context context) {
        context.processBean((Type)((Object)InRequestInterceptor.class));
        context.processBean((Type)((Object)InSessionInterceptor.class));
        context.processBean((Type)((Object)InConversationInterceptor.class));
        context.processBean((Type)((Object)CdiUnitInitialListenerImpl.class));
        if (this.servletApi5) {
            context.processBean((Type)((Object)ServletAPI5Mocks.class));
        } else {
            context.processBean((Type)((Object)ServletAPI6Mocks.class));
        }
    }

    private void discoverServletObjectsProducers(DiscoveryExtension.Context context) {
        context.processBean((Type)((Object)ServletObjectsProducer.class));
    }
}

