/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdiunit.internal.producerconfig;

import io.github.cdiunit.ProducerConfig;
import io.github.cdiunit.internal.TestConfiguration;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanAttributes;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.enterprise.inject.spi.ProducerFactory;
import jakarta.enterprise.util.AnnotationLiteral;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ProducerConfigExtension
implements Extension {
    private final TestConfiguration testConfiguration;
    private final Map<Class<? extends Annotation>, Map<Method, Annotation>> configurations = new HashMap<Class<? extends Annotation>, Map<Method, Annotation>>();

    public ProducerConfigExtension() {
        this(null);
    }

    public ProducerConfigExtension(TestConfiguration testConfiguration) {
        this.testConfiguration = testConfiguration;
    }

    void afterBeanDiscovery(@Observes AfterBeanDiscovery abd, BeanManager bm) throws Exception {
        Class<?> testClass = this.testConfiguration.getTestClass();
        while (!Object.class.equals(testClass)) {
            ProducerConfigExtension.addConfigValues(this.configurations, null, testClass.getAnnotations());
            for (Method m2 : testClass.getDeclaredMethods()) {
                ProducerConfigExtension.addConfigValues(this.configurations, m2, m2.getAnnotations());
            }
            testClass = testClass.getSuperclass();
        }
        Set annotationClasses = this.configurations.values().stream().flatMap(m -> m.values().stream()).map(Object::getClass).collect(Collectors.toSet());
        ProducerFactory<ProducerConfigExtension> producerFactory = this.getProducerFactory(bm);
        for (Class annotationClass : annotationClasses) {
            AnnotatedType at = bm.createAnnotatedType(annotationClass);
            BeanAttributes ba = bm.createBeanAttributes(at);
            Bean bean = bm.createBean(ba, ProducerConfigExtension.class, producerFactory);
            abd.addBean(bean);
        }
    }

    private static void addConfigValues(Map<Class<? extends Annotation>, Map<Method, Annotation>> values, Method m, Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (!annotation.annotationType().isAnnotationPresent(ProducerConfig.class)) continue;
            if (!Modifier.isPublic(annotation.annotationType().getModifiers())) {
                throw new RuntimeException("ProducerConfig annotation classes must be public");
            }
            values.computeIfAbsent(annotation.annotationType(), k -> new HashMap()).put(m, annotation);
        }
    }

    Object produceConfigValue(InjectionPoint ip) {
        Map<Method, Annotation> values = this.configurations.get(ip.getType());
        if (values == null) {
            return null;
        }
        Annotation result = values.get(this.testConfiguration.getTestMethod());
        return result != null ? result : values.get(null);
    }

    private ProducerFactory<ProducerConfigExtension> getProducerFactory(BeanManager bm) {
        AnnotatedType at = bm.createAnnotatedType(ProducerConfigExtension.class);
        return at.getMethods().stream().filter(m -> "produceConfigValue".equals(m.getJavaMember().getName())).findFirst().map(m -> bm.getProducerFactory(m, this.createProducerBean())).orElseThrow(() -> new IllegalStateException("can't find my own method ProducerConfigExtension.produceConfigValue"));
    }

    private Bean<ProducerConfigExtension> createProducerBean() {
        final ProducerConfigExtension extension = this;
        return new Bean<ProducerConfigExtension>(){

            public Set<Type> getTypes() {
                HashSet<Type> types = new HashSet<Type>();
                types.add((Type)((Object)ProducerConfigExtension.class));
                types.add((Type)((Object)Extension.class));
                types.add((Type)((Object)Object.class));
                return types;
            }

            public Set<Annotation> getQualifiers() {
                HashSet<Annotation> qualifiers = new HashSet<Annotation>();
                qualifiers.add((Annotation)new AnnotationLiteral<Default>(){});
                qualifiers.add((Annotation)new AnnotationLiteral<Any>(){});
                return qualifiers;
            }

            public Class<? extends Annotation> getScope() {
                return Dependent.class;
            }

            public String getName() {
                return null;
            }

            public Set<Class<? extends Annotation>> getStereotypes() {
                return Collections.emptySet();
            }

            public boolean isAlternative() {
                return false;
            }

            public ProducerConfigExtension create(CreationalContext<ProducerConfigExtension> creationalContext) {
                return extension;
            }

            public void destroy(ProducerConfigExtension instance, CreationalContext<ProducerConfigExtension> ctx) {
            }

            public Class<?> getBeanClass() {
                return ProducerConfigExtension.class;
            }

            public Set<InjectionPoint> getInjectionPoints() {
                return Collections.emptySet();
            }

            public boolean isNullable() {
                return false;
            }
        };
    }
}

