/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdiunit.internal.jaxrs;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.core.EntityTag;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Request;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.Variant;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jboss.resteasy.core.request.ServerDrivenNegotiation;
import org.jboss.resteasy.plugins.server.servlet.ServletUtil;
import org.jboss.resteasy.specimpl.MultivaluedMapImpl;
import org.jboss.resteasy.util.DateUtil;
import org.jboss.resteasy.util.Encode;

public class RequestImpl
implements Request {
    private final HttpHeaders headers;
    private String varyHeader;
    private final String httpMethod;
    private final HttpServletRequest request;
    private final HttpServletResponse response;

    public RequestImpl(HttpServletRequest request, HttpServletResponse response) {
        this.headers = ServletUtil.extractHttpHeaders((HttpServletRequest)request);
        this.httpMethod = request.getMethod().toUpperCase();
        this.request = request;
        this.response = response;
    }

    public String getMethod() {
        return this.httpMethod;
    }

    public MultivaluedMap<String, String> getFormParameters() {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        Map parameterMap = this.request.getParameterMap();
        for (Map.Entry entry : parameterMap.entrySet()) {
            for (String value : (String[])entry.getValue()) {
                params.add((Object)((String)entry.getKey()), (Object)value);
            }
        }
        return Encode.decode((MultivaluedMap)params);
    }

    public Variant selectVariant(List<Variant> variants) throws IllegalArgumentException {
        if (variants == null || variants.isEmpty()) {
            throw new IllegalArgumentException("Variant list must not be zero");
        }
        ServerDrivenNegotiation negotiation = new ServerDrivenNegotiation();
        MultivaluedMap requestHeaders = this.headers.getRequestHeaders();
        negotiation.setAcceptHeaders((List)requestHeaders.get((Object)"Accept"));
        negotiation.setAcceptCharsetHeaders((List)requestHeaders.get((Object)"Accept-Charset"));
        negotiation.setAcceptEncodingHeaders((List)requestHeaders.get((Object)"Accept-Encoding"));
        negotiation.setAcceptLanguageHeaders((List)requestHeaders.get((Object)"Accept-Language"));
        this.varyHeader = RequestImpl.createVaryHeader(variants);
        this.response.addHeader("Vary", this.varyHeader);
        return negotiation.getBestMatch(variants);
    }

    public static String createVaryHeader(List<Variant> variants) {
        boolean accept = false;
        boolean acceptLanguage = false;
        boolean acceptEncoding = false;
        for (Variant variant : variants) {
            if (variant.getMediaType() != null) {
                accept = true;
            }
            if (variant.getLanguage() != null) {
                acceptLanguage = true;
            }
            if (variant.getEncoding() == null) continue;
            acceptEncoding = true;
        }
        Object vary = null;
        if (accept) {
            vary = "Accept";
        }
        if (acceptLanguage) {
            vary = vary == null ? "Accept-Language" : (String)vary + ", Accept-Language";
        }
        if (acceptEncoding) {
            vary = vary == null ? "Accept-Encoding" : (String)vary + ", Accept-Encoding";
        }
        return vary;
    }

    public List<EntityTag> convertEtag(List<String> tags) {
        ArrayList<EntityTag> result = new ArrayList<EntityTag>();
        for (String tag : tags) {
            String[] split;
            for (String etag : split = tag.split(",")) {
                result.add(EntityTag.valueOf((String)etag.trim()));
            }
        }
        return result;
    }

    public Response.ResponseBuilder ifMatch(List<EntityTag> ifMatch, EntityTag eTag) {
        boolean match = false;
        for (EntityTag tag : ifMatch) {
            if (!tag.equals((Object)eTag) && !"*".equals(tag.getValue())) continue;
            match = true;
            break;
        }
        if (match) {
            return null;
        }
        return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).tag(eTag);
    }

    public Response.ResponseBuilder ifNoneMatch(List<EntityTag> ifMatch, EntityTag eTag) {
        boolean match = false;
        for (EntityTag tag : ifMatch) {
            if (!tag.equals((Object)eTag) && !"*".equals(tag.getValue())) continue;
            match = true;
            break;
        }
        if (match) {
            if ("GET".equals(this.httpMethod) || "HEAD".equals(this.httpMethod)) {
                return Response.notModified((EntityTag)eTag);
            }
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).tag(eTag);
        }
        return null;
    }

    public Response.ResponseBuilder evaluatePreconditions(EntityTag eTag) {
        List ifNoneMatch;
        if (eTag == null) {
            throw new IllegalArgumentException("eTag param null");
        }
        Response.ResponseBuilder builder = null;
        List ifMatch = (List)this.headers.getRequestHeaders().get((Object)"If-Match");
        if (ifMatch != null && !ifMatch.isEmpty()) {
            builder = this.ifMatch(this.convertEtag(ifMatch), eTag);
        }
        if (builder == null && (ifNoneMatch = (List)this.headers.getRequestHeaders().get((Object)"If-None-Match")) != null && !ifNoneMatch.isEmpty()) {
            builder = this.ifNoneMatch(this.convertEtag(ifNoneMatch), eTag);
        }
        if (builder != null) {
            builder.tag(eTag);
        }
        if (builder != null && this.varyHeader != null) {
            builder.header("Vary", (Object)this.varyHeader);
        }
        return builder;
    }

    public Response.ResponseBuilder ifModifiedSince(String strDate, Date lastModified) {
        Date date = DateUtil.parseDate((String)strDate);
        if (date.getTime() >= lastModified.getTime()) {
            return Response.notModified();
        }
        return null;
    }

    public Response.ResponseBuilder ifUnmodifiedSince(String strDate, Date lastModified) {
        Date date = DateUtil.parseDate((String)strDate);
        if (date.getTime() >= lastModified.getTime()) {
            return null;
        }
        return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).lastModified(lastModified);
    }

    public Response.ResponseBuilder evaluatePreconditions(Date lastModified) {
        String ifUnmodifiedSince;
        if (lastModified == null) {
            throw new IllegalArgumentException("lastModified param null");
        }
        Response.ResponseBuilder builder = null;
        String ifModifiedSince = (String)this.headers.getRequestHeaders().getFirst((Object)"If-Modified-Since");
        if (ifModifiedSince != null) {
            builder = this.ifModifiedSince(ifModifiedSince, lastModified);
        }
        if (builder == null && (ifUnmodifiedSince = (String)this.headers.getRequestHeaders().getFirst((Object)"If-Unmodified-Since")) != null) {
            builder = this.ifUnmodifiedSince(ifUnmodifiedSince, lastModified);
        }
        if (builder != null && this.varyHeader != null) {
            builder.header("Vary", (Object)this.varyHeader);
        }
        return builder;
    }

    public Response.ResponseBuilder evaluatePreconditions(Date lastModified, EntityTag eTag) {
        if (lastModified == null) {
            throw new IllegalArgumentException("lastModified param null");
        }
        if (eTag == null) {
            throw new IllegalArgumentException("eTag param null");
        }
        Response.ResponseBuilder rtn = null;
        Response.ResponseBuilder lastModifiedBuilder = this.evaluatePreconditions(lastModified);
        Response.ResponseBuilder etagBuilder = this.evaluatePreconditions(eTag);
        if (lastModifiedBuilder == null && etagBuilder == null) {
            rtn = null;
        } else if (lastModifiedBuilder != null && etagBuilder == null) {
            rtn = lastModifiedBuilder;
        } else if (lastModifiedBuilder == null && etagBuilder != null) {
            rtn = etagBuilder;
        } else {
            rtn = lastModifiedBuilder;
            rtn.tag(eTag);
        }
        if (rtn != null && this.varyHeader != null) {
            rtn.header("Vary", (Object)this.varyHeader);
        }
        return rtn;
    }

    public Response.ResponseBuilder evaluatePreconditions() {
        List ifMatch = (List)this.headers.getRequestHeaders().get((Object)"If-Match");
        if (ifMatch == null || ifMatch.isEmpty()) {
            return null;
        }
        return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED);
    }
}

