/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdiunit.internal.activatescopes;

import io.github.cdiunit.ActivateScopes;
import io.github.cdiunit.internal.DiscoveryExtension;
import io.github.cdiunit.internal.activatescopes.ScopesExtension;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;

public class ActivateScopesDiscoveryExtension
implements DiscoveryExtension {
    private final Set<Class<? extends Annotation>> scopes = new LinkedHashSet<Class<? extends Annotation>>();

    @Override
    public void bootstrap(DiscoveryExtension.BootstrapDiscoveryContext bdc) {
        bdc.discoverClass(this::discoverClass);
        bdc.discoverMethod(this::discoverMethod);
        bdc.afterDiscovery(this::afterDiscovery);
    }

    private void discoverClass(DiscoveryExtension.Context context, Class<?> cls) {
        this.discover(context, cls.getAnnotation(ActivateScopes.class));
        this.discover(context, cls.getAnnotation(ActivateScopes.All.class));
    }

    private void discoverMethod(DiscoveryExtension.Context context, Method method) {
        this.discover(context, method.getAnnotation(ActivateScopes.class));
        this.discover(context, method.getAnnotation(ActivateScopes.All.class));
    }

    private void discover(DiscoveryExtension.Context context, ActivateScopes activateScopes) {
        if (activateScopes == null) {
            return;
        }
        Arrays.stream(activateScopes.value()).forEach(this.scopes::add);
    }

    private void discover(DiscoveryExtension.Context context, ActivateScopes.All activateScopes) {
        if (activateScopes == null) {
            return;
        }
        Arrays.stream(activateScopes.value()).forEach(scope -> this.discover(context, (ActivateScopes)scope));
    }

    private void afterDiscovery(DiscoveryExtension.Context context) {
        if (!this.scopes.isEmpty()) {
            context.extension(new ScopesExtension(this.scopes));
        }
    }
}

