/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdiunit.internal;

import io.github.cdiunit.internal.CachingClassGraphScanner;
import io.github.cdiunit.internal.DefaultBeanArchiveScanner;
import io.github.cdiunit.internal.DefaultBootstrapDiscoveryContext;
import io.github.cdiunit.internal.DefaultDiscoveryContext;
import io.github.cdiunit.internal.DiscoveryExtension;
import io.github.cdiunit.internal.QuietDiscovery;
import io.github.cdiunit.internal.TestConfiguration;
import jakarta.enterprise.inject.spi.Extension;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.ServiceLoader;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.jboss.weld.environment.se.Weld;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WeldHelper {
    private static final Logger log = LoggerFactory.getLogger(WeldHelper.class);

    private WeldHelper() {
    }

    public static Weld configureWeld(TestConfiguration testConfiguration) {
        DefaultBootstrapDiscoveryContext bdc = new DefaultBootstrapDiscoveryContext();
        ServiceLoader<DiscoveryExtension> discoveryExtensions = ServiceLoader.load(DiscoveryExtension.class);
        discoveryExtensions.forEach(extension -> extension.bootstrap(bdc));
        Consumer<DiscoveryExtension.Context> discoverExtension = bdc.discoverExtension;
        BiConsumer<DiscoveryExtension.Context, Class<?>> discoverClass = bdc.discoverClass;
        BiConsumer<DiscoveryExtension.Context, Field> discoverField = bdc.discoverField;
        BiConsumer<DiscoveryExtension.Context, Method> discoverMethod = bdc.discoverMethod;
        Consumer<DiscoveryExtension.Context> afterDiscovery = bdc.afterDiscovery;
        CachingClassGraphScanner scanner = new CachingClassGraphScanner(new DefaultBeanArchiveScanner());
        DefaultDiscoveryContext discoveryContext = new DefaultDiscoveryContext(scanner, testConfiguration);
        LinkedHashSet discoveredClasses = new LinkedHashSet();
        HashSet classesProcessed = new HashSet();
        discoverExtension.accept(discoveryContext);
        discoveryContext.processBean(testConfiguration.getTestClass());
        testConfiguration.getAdditionalClasses().forEach(discoveryContext::processBean);
        while (discoveryContext.hasClassesToProcess()) {
            Class<?> cls = discoveryContext.nextClassToProcess();
            boolean candidate = scanner.isContainedInBeanArchive(cls) || Extension.class.isAssignableFrom(cls);
            boolean bl = classesProcessed.contains(cls);
            boolean primitive = cls.isPrimitive();
            boolean ignored = discoveryContext.isIgnored(cls);
            if (candidate && !bl && !primitive && !ignored) {
                classesProcessed.add(cls);
                if (!cls.isAnnotation()) {
                    discoveredClasses.add(cls);
                }
                try {
                    discoverClass.accept(discoveryContext, cls);
                    for (Field field : cls.getDeclaredFields()) {
                        discoverField.accept(discoveryContext, field);
                    }
                    for (AccessibleObject accessibleObject : cls.getDeclaredMethods()) {
                        discoverMethod.accept(discoveryContext, (Method)accessibleObject);
                    }
                }
                catch (NoClassDefFoundError ncdf) {
                    throw new IllegalStateException(String.format("Can not discover %s", cls), ncdf);
                }
            }
            discoveryContext.processed(cls);
        }
        afterDiscovery.accept(discoveryContext);
        Weld weld = new Weld("cdi-unit-" + UUID.randomUUID()).disableDiscovery();
        discoveryContext.configure(weld);
        for (Class clazz : discoveredClasses) {
            weld.addBeanClass(clazz);
        }
        log.info("CDI-Unit discovered:");
        for (Class clazz : discoveredClasses) {
            String clsName = clazz.getName();
            if (WeldHelper.quietDiscovery(clazz)) {
                log.debug(clsName);
                continue;
            }
            log.info(clsName);
        }
        return weld;
    }

    static boolean quietDiscovery(Class<?> c) {
        if (c.isAnnotationPresent(QuietDiscovery.class)) {
            return true;
        }
        Package p = c.getPackage();
        if (p.isAnnotationPresent(QuietDiscovery.class)) {
            return true;
        }
        String pName = p.getName();
        return pName.startsWith("io.github.cdiunit") && pName.contains(".internal");
    }
}

