/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdiunit.internal;

import io.github.cdiunit.internal.BeanArchiveScanner;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultBeanArchiveScanner
implements BeanArchiveScanner {
    private static final Logger log = LoggerFactory.getLogger(DefaultBeanArchiveScanner.class);

    @Override
    public Collection<URL> findBeanArchives(Collection<URL> classPathEntries) throws IOException {
        HashSet<URL> result = new HashSet<URL>();
        HashSet<URL> entrySet = new HashSet<URL>(classPathEntries);
        for (URL url : classPathEntries) {
            entrySet.addAll(DefaultBeanArchiveScanner.getEntriesFromManifestClasspath(url));
        }
        for (URL url : entrySet) {
            try (URLClassLoader classLoader = new URLClassLoader(new URL[]{url}, null);){
                if (url.getFile().endsWith("/classes/")) {
                    URL webInfBeans = new URL(url, "../../src/main/webapp/WEB-INF/beans.xml");
                    try (InputStream ignore2 = webInfBeans.openStream();){
                        result.add(url);
                    }
                    catch (IOException ignore2) {
                        // empty catch block
                    }
                }
                URL beansXml = classLoader.getResource("META-INF/beans.xml");
                URL cdiUnitArchive = classLoader.getResource("META-INF/io.github.cdiunit-archive");
                if (cdiUnitArchive == null && beansXml == null && !this.isDirectory(url)) continue;
                result.add(url);
            }
        }
        log.debug("CDI classpath entries discovered:");
        for (URL url : result) {
            log.debug("{}", (Object)url);
        }
        return result;
    }

    private boolean isDirectory(URL classpathEntry) {
        try {
            return new File(classpathEntry.toURI()).isDirectory();
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return false;
    }

    private static Set<URL> getEntriesFromManifestClasspath(URL url) throws IOException {
        HashSet<URL> manifestURLs = new HashSet<URL>();
        try (InputStream in = url.openStream();
             JarInputStream jar = new JarInputStream(in);){
            String classpath;
            Manifest manifest = jar.getManifest();
            if (manifest != null && (classpath = (String)manifest.getMainAttributes().get(Attributes.Name.CLASS_PATH)) != null) {
                String[] manifestEntries;
                for (String entry : manifestEntries = classpath.split(" ?file:")) {
                    if (entry.length() <= 0) continue;
                    manifestURLs.add(new URL("file:" + entry));
                }
            }
        }
        return manifestURLs;
    }
}

