/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdiunit.internal;

import io.github.cdiunit.ActivatedAlternatives;
import io.github.cdiunit.AdditionalClasses;
import io.github.cdiunit.AdditionalClasspaths;
import io.github.cdiunit.AdditionalPackages;
import io.github.cdiunit.internal.DiscoveryExtension;
import jakarta.enterprise.inject.Alternative;
import jakarta.enterprise.inject.Stereotype;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class CdiUnitDiscoveryExtension
implements DiscoveryExtension {
    @Override
    public void bootstrap(DiscoveryExtension.BootstrapDiscoveryContext bdc) {
        bdc.discoverClass(this::discoverClass);
    }

    private void discoverClass(DiscoveryExtension.Context context, Class<?> cls) {
        this.discover(context, cls.getAnnotation(AdditionalClasspaths.class));
        this.discover(context, cls.getAnnotation(AdditionalPackages.class));
        this.discover(context, cls.getAnnotation(AdditionalClasses.class));
        this.discover(context, cls.getAnnotation(ActivatedAlternatives.class));
        this.discover(context, cls.getAnnotations());
        this.discover(context, cls.getGenericSuperclass());
    }

    private void discover(DiscoveryExtension.Context context, AdditionalClasspaths additionalClasspaths) {
        if (additionalClasspaths == null) {
            return;
        }
        List<Class<?>> baseClasses = Arrays.stream(additionalClasspaths.value()).collect(Collectors.toList());
        context.scanBeanArchives(baseClasses).forEach(context::processBean);
    }

    private void discover(DiscoveryExtension.Context context, AdditionalPackages additionalPackages) {
        if (additionalPackages == null) {
            return;
        }
        List<Class<?>> baseClasses = Arrays.stream(additionalPackages.value()).collect(Collectors.toList());
        context.scanPackages(baseClasses).forEach(context::processBean);
    }

    private void discover(DiscoveryExtension.Context context, AdditionalClasses additionalClasses) {
        if (additionalClasses == null) {
            return;
        }
        Arrays.stream(additionalClasses.value()).forEach(context::processBean);
        Arrays.stream(additionalClasses.late()).forEach(context::processBean);
    }

    private void discover(DiscoveryExtension.Context context, ActivatedAlternatives alternativeClasses) {
        if (alternativeClasses == null) {
            return;
        }
        for (Class<?> alternativeClass : alternativeClasses.value()) {
            context.processBean(alternativeClass);
            if (CdiUnitDiscoveryExtension.isAlternativeStereotype(alternativeClass)) continue;
            context.enableAlternative(alternativeClass);
        }
    }

    private static boolean isAlternativeStereotype(Class<?> c) {
        return c.isAnnotationPresent(Stereotype.class) && c.isAnnotationPresent(Alternative.class);
    }

    private void discover(DiscoveryExtension.Context context, Annotation[] annotations) {
        Arrays.stream(annotations).filter(this::exceptCdiUnitAnnotations).map(Annotation::annotationType).forEach(context::processBean);
    }

    private boolean exceptCdiUnitAnnotations(Annotation annotation) {
        return !"io.github.cdiunit".equals(annotation.annotationType().getPackage().getName());
    }

    private void discover(DiscoveryExtension.Context context, Type genericSuperclass) {
        Optional.ofNullable(genericSuperclass).filter(o -> o != Object.class).ifPresent(context::processBean);
    }
}

