/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdiunit.internal;

import io.github.cdiunit.internal.BeanArchiveScanner;
import io.github.cdiunit.internal.ClasspathScanner;
import io.github.cdiunit.internal.ExceptionUtils;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ScanResult;
import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CachingClassGraphScanner
implements ClasspathScanner {
    static final int DEFAULT_NUM_WORKER_THREADS = Math.max(2, (int)Math.ceil(Math.min(4.0f, (float)Runtime.getRuntime().availableProcessors() * 0.75f) + (float)Runtime.getRuntime().availableProcessors() * 1.25f));
    static final ExecutorService scanExecutor = Executors.newWorkStealingPool(DEFAULT_NUM_WORKER_THREADS);
    static ConcurrentHashMap<Object, Object> cache = new ConcurrentHashMap();
    private final BeanArchiveScanner beanArchiveScanner;

    public CachingClassGraphScanner(BeanArchiveScanner beanArchiveScanner) {
        this.beanArchiveScanner = beanArchiveScanner;
    }

    private <K, V> V computeIfAbsent(K k, Supplier<V> computeValue) {
        return (V)cache.computeIfAbsent(k, (? super K o) -> computeValue.get());
    }

    private List<URL> getClasspathURLs() {
        return this.computeIfAbsent(this.getClass().getClassLoader(), this::computeClasspathUrls);
    }

    @Override
    public Collection<URL> getBeanArchives() {
        List<URL> urls = this.getClasspathURLs();
        return this.computeIfAbsent(this.computeKey(urls.stream()), () -> this.findBeanArchives(urls));
    }

    private Collection<URL> findBeanArchives(List<URL> urls) {
        try {
            return this.beanArchiveScanner.findBeanArchives(urls);
        }
        catch (Exception e) {
            throw ExceptionUtils.asRuntimeException(e);
        }
    }

    private List<URL> computeClasspathUrls() {
        try (ScanResult scan = new ClassGraph().disableNestedJarScanning().disableModuleScanning().scan(scanExecutor, DEFAULT_NUM_WORKER_THREADS);){
            List list = scan.getClasspathURLs();
            return list;
        }
    }

    @Override
    public List<String> getClassNamesForClasspath(URL[] urls) {
        return this.computeIfAbsent(this.computeKey(Arrays.stream(urls)), () -> this.computeClassNamesForClasspath(urls));
    }

    private Object computeKey(Stream<URL> urls) {
        return urls.map(URL::toString).collect(Collectors.joining(File.pathSeparator));
    }

    private List<String> computeClassNamesForClasspath(URL[] urls) {
        try (ScanResult scan = new ClassGraph().disableNestedJarScanning().enableClassInfo().ignoreClassVisibility().overrideClasspath(Arrays.asList(urls)).scan(scanExecutor, DEFAULT_NUM_WORKER_THREADS);){
            List list = scan.getAllClasses().getNames();
            return list;
        }
    }

    @Override
    public List<String> getClassNamesForPackage(String packageName, URL url) {
        return this.computeIfAbsent(this.computeKey(packageName, url), () -> this.computeClassNamesForPackage(packageName, url));
    }

    private Object computeKey(String packageName, URL url) {
        return String.format("%s@%s", packageName, url);
    }

    private List<String> computeClassNamesForPackage(String packageName, URL url) {
        try (ScanResult scan = new ClassGraph().disableNestedJarScanning().enableClassInfo().ignoreClassVisibility().overrideClasspath(new Object[]{url}).acceptPackagesNonRecursive(new String[]{packageName}).scan(scanExecutor, DEFAULT_NUM_WORKER_THREADS);){
            List list = scan.getAllClasses().getNames();
            return list;
        }
    }
}

