/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdiunit.internal;

import io.github.cdiunit.internal.ExceptionUtils;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public final class BeanLifecycleHelper {
    public static void invokePostConstruct(Class<?> targetClass, Object target) throws Throwable {
        BeanLifecycleHelper.invokeLifecycleMethods(targetClass, PostConstruct.class, target);
    }

    public static void invokePreDestroy(Class<?> targetClass, Object target) throws Throwable {
        BeanLifecycleHelper.invokeLifecycleMethods(targetClass, PreDestroy.class, target);
    }

    private static void invokeLifecycleMethods(Class<?> targetClass, Class<? extends Annotation> a, Object target) throws Throwable {
        BeanLifecycleHelper.findLifecycleMethods(targetClass, a).forEach(m -> {
            try {
                m.setAccessible(true);
                m.invoke(target, new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw ExceptionUtils.asRuntimeException(e);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause == null) {
                    cause = e;
                }
                throw ExceptionUtils.asRuntimeException(cause);
            }
        });
    }

    private static Collection<Method> findLifecycleMethods(final Class<?> targetClass, Class<? extends Annotation> a) {
        Spliterator superClassSpliterator = new Spliterator<Class<?>>(){
            Class<?> aClass;
            {
                this.aClass = targetClass;
            }

            @Override
            public boolean tryAdvance(Consumer<? super Class<?>> action) {
                if (this.aClass == null) {
                    return false;
                }
                action.accept(this.aClass);
                this.aClass = this.aClass.getSuperclass();
                return true;
            }

            @Override
            public Spliterator<Class<?>> trySplit() {
                return null;
            }

            @Override
            public long estimateSize() {
                return 0L;
            }

            @Override
            public int characteristics() {
                return 1297;
            }
        };
        List superclasses = StreamSupport.stream(superClassSpliterator, false).collect(Collectors.toList());
        Collections.reverse(superclasses);
        return superclasses.stream().flatMap(c -> Arrays.stream(c.getDeclaredMethods())).filter(m -> m.isAnnotationPresent(a)).filter(m -> m.getParameterCount() == 0).filter(m -> Void.TYPE.equals(m.getReturnType())).collect(Collectors.toList());
    }

    private BeanLifecycleHelper() throws IllegalAccessException {
        ExceptionUtils.illegalInstantiation();
    }
}

