/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdiunit.junit4.internal;

import io.github.cdiunit.IsolationLevel;
import io.github.cdiunit.internal.TestConfiguration;
import io.github.cdiunit.internal.TestLifecycle;
import io.github.cdiunit.junit4.internal.ActivateScopes;
import io.github.cdiunit.junit4.internal.AroundMethod;
import io.github.cdiunit.junit4.internal.ExpectStartupException;
import io.github.cdiunit.junit4.internal.InjectTestInstance;
import io.github.cdiunit.junit4.internal.InvokeInterceptors;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.rules.MethodRule;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

public class CdiJUnitRule
implements TestRule,
MethodRule {
    private static final ConcurrentMap<Class<?>, TestLifecycle> testLifecyclePerClass = new ConcurrentHashMap();
    private static final ConcurrentMap<Class<?>, AtomicBoolean> contextsActivatedPerClass = new ConcurrentHashMap();

    public Statement apply(final Statement base, Description description) {
        Class testClass = description.getTestClass();
        final TestLifecycle testLifecycle = this.getTestLifecycle(testClass, null, null);
        Statement statement = base;
        statement = new Statement(){

            public void evaluate() throws Throwable {
                try {
                    testLifecycle.beforeTestClass();
                    base.evaluate();
                }
                finally {
                    testLifecycle.afterTestClass();
                }
            }
        };
        statement = new Cleanup(statement, testClass);
        return statement;
    }

    private TestLifecycle getTestLifecycle(Class<?> testClass, Method method, IsolationLevel initIsolationLevel) {
        TestLifecycle testLifecycle = testLifecyclePerClass.computeIfAbsent(testClass, c -> {
            TestConfiguration testConfiguration = new TestConfiguration(testClass, method);
            TestLifecycle result = new TestLifecycle(testConfiguration);
            if (initIsolationLevel != null) {
                result.setIsolationLevel(initIsolationLevel);
            }
            return result;
        });
        testLifecycle.setTestMethod(method);
        return testLifecycle;
    }

    public Statement apply(Statement base, FrameworkMethod method, Object testInstance) {
        AtomicBoolean contextsActivated = contextsActivatedPerClass.computeIfAbsent(testInstance.getClass(), c -> new AtomicBoolean());
        TestLifecycle testLifecycle = this.getTestLifecycle(testInstance.getClass(), method.getMethod(), IsolationLevel.PER_METHOD);
        Statement statement = new InvokeInterceptors(base, testInstance, testLifecycle);
        statement = new ActivateScopes(statement, testLifecycle, contextsActivated);
        statement = new ExpectStartupException(statement, testLifecycle);
        statement = new AroundMethod(statement, testLifecycle);
        statement = new InjectTestInstance(statement, testLifecycle, testInstance);
        return statement;
    }

    private static class Cleanup
    extends Statement {
        private final Statement base;
        private final Class<?> testClass;

        public Cleanup(Statement base, Class<?> testClass) {
            this.base = base;
            this.testClass = testClass;
        }

        public void evaluate() throws Throwable {
            try {
                this.base.evaluate();
            }
            finally {
                testLifecyclePerClass.remove(this.testClass);
                contextsActivatedPerClass.remove(this.testClass);
            }
        }
    }
}

