/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdiunit.internal.resource;

import jakarta.annotation.Resource;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Produces;
import jakarta.enterprise.inject.Typed;
import jakarta.enterprise.inject.spi.AnnotatedField;
import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessAnnotatedType;
import jakarta.enterprise.inject.spi.configurator.AnnotatedTypeConfigurator;
import jakarta.enterprise.util.AnnotationLiteral;
import jakarta.inject.Inject;
import java.beans.BeanInfo;
import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Optional;
import org.jboss.weld.literal.NamedLiteral;

public class InjectAtResourceExtension
implements Extension {
    private static final AnnotationLiteral<Inject> INJECT_INSTANCE = new AnnotationLiteral<Inject>(){
        private static final long serialVersionUID = 1L;
    };

    <T> void processAnnotatedType(@Observes ProcessAnnotatedType<T> pat) throws IntrospectionException {
        AnnotatedTypeConfigurator builder = pat.configureAnnotatedType();
        BeanInfo beanInfo = Introspector.getBeanInfo(pat.getAnnotatedType().getJavaClass());
        builder.filterFields(this::eligibleField).forEach(field -> {
            AnnotatedField annotatedField = field.getAnnotated();
            Field javaMember = annotatedField.getJavaMember();
            Resource resource = (Resource)annotatedField.getAnnotation(Resource.class);
            boolean producesPresent = annotatedField.isAnnotationPresent(Produces.class);
            if (!producesPresent) {
                field.add(INJECT_INSTANCE);
            }
            field.remove(a -> a.annotationType().equals(Resource.class));
            String name = resource.name();
            if (name.isEmpty()) {
                name = javaMember.getName();
            }
            field.add((Annotation)new NamedLiteral(name));
            if (producesPresent) {
                Class<?> type = resource.type();
                if (type == Object.class) {
                    type = javaMember.getType();
                }
                Class[] types = new Class[]{type};
                field.add((Annotation)Typed.Literal.of((Class[])types));
            }
        });
        builder.filterMethods(this::eligibleMethod).forEach(method -> {
            AnnotatedMethod annotatedMethod = method.getAnnotated();
            Method javaMember = annotatedMethod.getJavaMember();
            Optional<PropertyDescriptor> propertyDescriptor = Arrays.stream(beanInfo.getPropertyDescriptors()).filter(o -> javaMember.equals(o.getReadMethod()) || javaMember.equals(o.getWriteMethod())).findAny();
            Resource resource = (Resource)annotatedMethod.getAnnotation(Resource.class);
            boolean producesPresent = annotatedMethod.isAnnotationPresent(Produces.class);
            if (!producesPresent) {
                method.add(INJECT_INSTANCE);
            }
            method.remove(a -> a.annotationType().equals(Resource.class));
            String name = resource.name();
            if (name.isEmpty()) {
                name = propertyDescriptor.map(FeatureDescriptor::getName).orElse(javaMember.getName());
            }
            NamedLiteral namedLiteral = new NamedLiteral(name);
            if (producesPresent) {
                method.add((Annotation)namedLiteral);
            } else {
                method.params().forEach(param -> param.add((Annotation)namedLiteral));
            }
            if (producesPresent) {
                Class type = resource.type();
                if (type == Object.class) {
                    type = propertyDescriptor.map(PropertyDescriptor::getPropertyType).orElse(null);
                }
                if (type == null) {
                    type = javaMember.getReturnType();
                }
                Class[] types = new Class[]{type};
                method.add((Annotation)Typed.Literal.of((Class[])types));
            }
        });
    }

    private <X> boolean eligibleField(AnnotatedField<? super X> field) {
        return !field.isAnnotationPresent(Inject.class) && field.isAnnotationPresent(Resource.class);
    }

    private <X> boolean eligibleMethod(AnnotatedMethod<? super X> method) {
        return !method.isAnnotationPresent(Inject.class) && method.isAnnotationPresent(Resource.class);
    }
}

