/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdiunit.internal.naming;

import io.github.cdiunit.internal.naming.CdiUnitContextFactory;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.AfterDeploymentValidation;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.BeforeShutdown;
import jakarta.enterprise.inject.spi.Extension;
import javax.naming.InitialContext;
import javax.naming.spi.NamingManager;

public class NamingExtension
implements Extension {
    private static final String JNDI_BEAN_MANAGER_NAME = "java:comp/BeanManager";
    private InitialContext boundToContext;

    void onAfterDeploymentValidation(@Observes AfterDeploymentValidation adv, BeanManager beanManager) throws Exception {
        String existingFactory = System.getProperty("java.naming.factory.initial");
        if (existingFactory == null && !NamingManager.hasInitialContextFactoryBuilder()) {
            NamingManager.setInitialContextFactoryBuilder(CdiUnitContextFactory::new);
        }
        this.boundToContext = new InitialContext();
        this.boundToContext.bind(JNDI_BEAN_MANAGER_NAME, (Object)beanManager);
    }

    void onBeforeShutdown(@Observes BeforeShutdown bs) throws Exception {
        if (this.boundToContext != null) {
            this.boundToContext.unbind(JNDI_BEAN_MANAGER_NAME);
            this.boundToContext.close();
        }
    }
}

