/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdiunit.internal.mockito;

import io.github.cdiunit.internal.ClassLookup;
import io.github.cdiunit.internal.DiscoveryExtension;
import io.github.cdiunit.internal.mockito.MockitoExtension;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;

public class MockitoDiscoveryExtension
implements DiscoveryExtension {
    private final Class<? extends Annotation> fieldAnnotation = ClassLookup.INSTANCE.lookup("org.mockito.Mock");

    @Override
    public void bootstrap(DiscoveryExtension.BootstrapDiscoveryContext bdc) {
        if (this.fieldAnnotation == null) {
            return;
        }
        bdc.discoverExtension(this::discoverCdiExtension);
        bdc.discoverField(this::discoverField);
    }

    private void discoverCdiExtension(DiscoveryExtension.Context context) {
        context.extension(new MockitoExtension());
    }

    private void discoverField(DiscoveryExtension.Context context, Field field) {
        if (field.isAnnotationPresent(this.fieldAnnotation)) {
            Class<?> type = field.getType();
            context.ignoreBean(type);
        }
    }
}

