/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdiunit.internal;

import io.github.cdiunit.internal.ExceptionUtils;
import io.github.cdiunit.internal.ThrowingStatement;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.InterceptionType;
import jakarta.enterprise.inject.spi.Interceptor;
import jakarta.interceptor.InvocationContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TestMethodInvocationContext<H>
implements InvocationContext {
    private final Object target;
    private final Method method;
    private final Object[] parameters;
    private final ThrowingStatement methodInvoker;
    private List<Interceptor<?>> interceptors = List.of();
    private Map<String, Object> contextData;
    private BeanManager beanManager;
    private int interceptorIndex;

    public TestMethodInvocationContext(Object target, Method method, Object[] parameters, ThrowingStatement methodInvoker) {
        this.target = target;
        this.method = method;
        this.parameters = parameters;
        this.methodInvoker = methodInvoker;
    }

    public void resolveInterceptors(BeanManager beanManager) {
        if (this.method == null) {
            return;
        }
        Annotation[] bindings = (Annotation[])Arrays.stream(this.method.getAnnotations()).filter(o -> beanManager.isInterceptorBinding(o.annotationType())).toArray(Annotation[]::new);
        if (bindings.length == 0) {
            return;
        }
        this.beanManager = beanManager;
        this.interceptors = beanManager.resolveInterceptors(InterceptionType.AROUND_INVOKE, bindings);
    }

    public Object getTarget() {
        return this.target;
    }

    public Object getTimer() {
        return null;
    }

    public Method getMethod() {
        return this.method;
    }

    public Constructor<?> getConstructor() {
        return null;
    }

    public Object[] getParameters() {
        return this.parameters;
    }

    public void setParameters(Object[] params) {
        throw new UnsupportedOperationException();
    }

    public Map<String, Object> getContextData() {
        if (this.contextData == null) {
            this.contextData = new HashMap<String, Object>();
        }
        return this.contextData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object proceed() throws Exception {
        if (this.interceptors.size() > this.interceptorIndex) {
            Object object;
            block7: {
                CreationalContext creationalContext;
                block8: {
                    Interceptor<?> interceptor = null;
                    creationalContext = null;
                    Object interceptorInstance = null;
                    try {
                        interceptor = this.interceptors.get(this.interceptorIndex++);
                        creationalContext = this.beanManager.createCreationalContext(interceptor);
                        interceptorInstance = interceptor.create(creationalContext);
                        object = interceptor.intercept(InterceptionType.AROUND_INVOKE, interceptorInstance, (InvocationContext)this);
                        if (creationalContext == null) break block7;
                        if (interceptorInstance == null || interceptor == null) break block8;
                    }
                    catch (Throwable throwable) {
                        if (creationalContext != null) {
                            if (interceptorInstance != null && interceptor != null) {
                                interceptor.destroy(interceptorInstance, creationalContext);
                            }
                            creationalContext.release();
                        }
                        throw throwable;
                    }
                    interceptor.destroy(interceptorInstance, creationalContext);
                }
                creationalContext.release();
            }
            return object;
        }
        try {
            this.methodInvoker.evaluate();
            return null;
        }
        catch (Throwable t) {
            throw ExceptionUtils.asRuntimeException(t);
        }
    }
}

