/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdiunit.internal;

import io.github.cdiunit.IsolationLevel;
import io.github.cdiunit.internal.BeanLifecycleHelper;
import io.github.cdiunit.internal.ExceptionUtils;
import io.github.cdiunit.internal.TestConfiguration;
import io.github.cdiunit.internal.ThrowingStatement;
import io.github.cdiunit.internal.WeldHelper;
import io.github.cdiunit.internal.events.EventsForwardingExtension;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.InjectionTarget;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.function.Consumer;
import org.jboss.weld.environment.se.Weld;
import org.jboss.weld.environment.se.WeldContainer;

public class TestLifecycle {
    private final TestConfiguration testConfiguration;
    private Weld weld;
    private WeldContainer container;
    private boolean needsExplicitInterceptorInvocation;
    private final Deque<AutoCloseable> instanceDisposers = new ArrayDeque<AutoCloseable>();
    private Throwable startupException;
    private IsolationLevel isolationLevel;
    private Consumer<TestLifecycle> doBeforeMethod = testLifecycle -> {};
    private Consumer<TestLifecycle> doAfterMethod = testLifecycle -> {};

    public TestLifecycle(TestConfiguration testConfiguration) {
        this.testConfiguration = testConfiguration;
        this.isolationLevel = testConfiguration.getIsolationLevel();
    }

    private void perform(IsolationLevel targetIsolationLevel, ThrowingStatement action) {
        if (this.isolationLevel != targetIsolationLevel) {
            return;
        }
        try {
            action.evaluate();
        }
        catch (Throwable t) {
            throw ExceptionUtils.asRuntimeException(t);
        }
    }

    protected void initWeld() {
        if (this.startupException != null) {
            return;
        }
        if (this.weld != null) {
            return;
        }
        try {
            this.weld = WeldHelper.configureWeld(this.testConfiguration);
            this.container = this.weld.initialize();
        }
        catch (Throwable t) {
            this.startupException = t;
        }
    }

    protected void shutdownWeld() throws Exception {
        try {
            while (!this.instanceDisposers.isEmpty()) {
                AutoCloseable instanceDisposer = this.instanceDisposers.pollLast();
                if (instanceDisposer == null) continue;
                instanceDisposer.close();
            }
        }
        finally {
            if (this.weld != null) {
                this.weld.shutdown();
                this.weld = null;
                this.container = null;
                this.startupException = null;
            }
        }
    }

    public <T> T createTest(Object outerInstance) throws Throwable {
        this.initWeld();
        this.checkStartupException();
        Class<?> testClass = this.testConfiguration.getTestClass();
        if (outerInstance == null) {
            Instance instance = this.getBeanManager().createInstance();
            Instance beanInstance = instance.select(testClass, new Annotation[0]);
            Object testInstance = beanInstance.get();
            this.instanceDisposers.add(() -> beanInstance.destroy(testInstance));
            return (T)testInstance;
        }
        Class<?> declaringClass = testClass.getDeclaringClass();
        if (declaringClass != null && declaringClass.isInstance(outerInstance)) {
            Constructor<?> constructor = testClass.getDeclaredConstructor(declaringClass);
            constructor.setAccessible(true);
            Object testInstance = constructor.newInstance(outerInstance);
            this.configureTest(testInstance);
            return (T)testInstance;
        }
        throw new IllegalStateException(String.format("Don't know how to instantiate %s", testClass));
    }

    public void configureTest(Object testInstance) throws Throwable {
        this.checkStartupException();
        Class<?> testClass = testInstance.getClass();
        if (!testClass.equals(this.testConfiguration.getTestClass())) {
            throw new IllegalStateException(String.format("mismatched test class: instance of %s provided while configured for %s", testClass, this.testConfiguration.getTestClass()));
        }
        this.initWeld();
        this.checkStartupException();
        this.needsExplicitInterceptorInvocation = true;
        BeanManager beanManager = this.container.getBeanManager();
        CreationalContext creationalContext = beanManager.createCreationalContext(null);
        AnnotatedType annotatedType = beanManager.createAnnotatedType(testClass);
        InjectionTarget injectionTarget = beanManager.getInjectionTargetFactory(annotatedType).createInjectionTarget(null);
        injectionTarget.inject(testInstance, creationalContext);
        this.instanceDisposers.add(() -> {
            injectionTarget.dispose(testInstance);
            creationalContext.release();
        });
        this.afterConfigure(testClass, testInstance);
    }

    protected void afterConfigure(Class<?> testClass, Object testInstance) throws Throwable {
        BeanLifecycleHelper.invokePostConstruct(testClass, testInstance);
        this.instanceDisposers.add(() -> {
            try {
                BeanLifecycleHelper.invokePreDestroy(testClass, testInstance);
            }
            catch (Throwable t) {
                throw ExceptionUtils.asRuntimeException(t);
            }
        });
        EventsForwardingExtension eventsForwarder = (EventsForwardingExtension)this.getBeanManager().getExtension(EventsForwardingExtension.class);
        this.addBeforeMethod(testLifecycle -> eventsForwarder.bind(testClass, testInstance));
        this.addAfterMethod(testLifecycle -> eventsForwarder.unbind());
    }

    protected void addBeforeMethod(Consumer<? super TestLifecycle> beforeMethod) {
        this.doBeforeMethod = this.doBeforeMethod.andThen(beforeMethod);
    }

    protected void addAfterMethod(Consumer<TestLifecycle> afterMethod) {
        this.doAfterMethod = afterMethod.andThen(this.doAfterMethod);
    }

    public void beforeTestClass() {
        this.perform(IsolationLevel.PER_CLASS, this::initWeld);
    }

    public void afterTestClass() throws Exception {
        this.perform(IsolationLevel.PER_CLASS, this::shutdownWeld);
    }

    public void beforeTestMethod() {
        this.perform(IsolationLevel.PER_METHOD, this::initWeld);
        this.doBeforeMethod.accept(this);
    }

    public void afterTestMethod() throws Exception {
        this.doAfterMethod.accept(this);
        this.perform(IsolationLevel.PER_METHOD, this::shutdownWeld);
        this.testConfiguration.setTestMethod(null);
    }

    public BeanManager getBeanManager() {
        this.checkStartupException();
        if (this.container == null) {
            throw new IllegalStateException("Weld container is not created yet");
        }
        return this.container.getBeanManager();
    }

    protected final void checkStartupException() {
        if (this.startupException != null) {
            throw ExceptionUtils.asRuntimeException(this.startupException);
        }
    }

    public void setTestMethod(Method method) {
        this.testConfiguration.setTestMethod(method);
    }

    public Method getTestMethod() {
        return this.testConfiguration.getTestMethod();
    }

    protected TestConfiguration getTestConfiguration() {
        return this.testConfiguration;
    }

    public boolean explicitInterceptorInvocation() {
        return this.needsExplicitInterceptorInvocation;
    }

    public void setIsolationLevel(IsolationLevel isolationLevel) {
        if (this.weld != null) {
            throw new IllegalStateException("Weld container is already created");
        }
        this.isolationLevel = isolationLevel;
    }

    public IsolationLevel getIsolationLevel() {
        return this.isolationLevel;
    }

    public Throwable getStartupException() {
        return this.startupException;
    }
}

