/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdiunit.internal;

import io.github.cdiunit.IgnoredClasses;
import io.github.cdiunit.internal.DiscoveryExtension;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;

public class IgnoredClassesDiscoveryExtension
implements DiscoveryExtension {
    @Override
    public void bootstrap(DiscoveryExtension.BootstrapDiscoveryContext bdc) {
        bdc.discoverClass(this::discoverClass);
        bdc.discoverField(this::discoverField);
        bdc.discoverMethod(this::discoverMethod);
    }

    private void discoverClass(DiscoveryExtension.Context context, Class<?> cls) {
        this.discover(context, cls.getAnnotation(IgnoredClasses.class));
    }

    private void discoverField(DiscoveryExtension.Context context, Field field) {
        if (field.isAnnotationPresent(IgnoredClasses.class)) {
            context.ignoreBean(field.getGenericType());
        }
    }

    private void discoverMethod(DiscoveryExtension.Context context, Method method) {
        if (method.isAnnotationPresent(IgnoredClasses.class)) {
            context.ignoreBean(method.getGenericReturnType());
        }
    }

    private void discover(DiscoveryExtension.Context context, IgnoredClasses ignoredClasses) {
        if (ignoredClasses == null) {
            return;
        }
        Arrays.stream(ignoredClasses.value()).forEach(context::ignoreBean);
        Arrays.stream(ignoredClasses.late()).forEach(context::ignoreBean);
    }
}

