/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdiunit.internal;

import java.net.URL;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ClasspathScanner {
    public static final Logger log = LoggerFactory.getLogger(ClasspathScanner.class);

    public Collection<URL> getBeanArchives();

    public List<String> getClassNamesForClasspath(URL[] var1);

    public List<String> getClassNamesForPackage(String var1, URL var2);

    default public URL getClasspathURL(Class<?> cls) {
        return Optional.ofNullable(cls).map(Class::getProtectionDomain).map(ProtectionDomain::getCodeSource).map(CodeSource::getLocation).map(this::getRealURL).orElse(null);
    }

    default public URL getRealURL(URL urlWithPotentialSymLink) {
        try {
            Path realPath = Paths.get(urlWithPotentialSymLink.toURI()).toRealPath(new LinkOption[0]);
            URL realURL = realPath.toUri().toURL();
            if (log.isDebugEnabled() && !realURL.equals(urlWithPotentialSymLink)) {
                log.debug("Adapting URL:" + urlWithPotentialSymLink + " to URL:" + realURL);
            }
            return realURL;
        }
        catch (Exception e) {
            log.warn("Could not try to find real path (without symlink, ...) for URL:" + urlWithPotentialSymLink.toString(), (Throwable)e);
            return urlWithPotentialSymLink;
        }
    }

    default public boolean isContainedInBeanArchive(Class<?> cls) {
        URL location = this.getClasspathURL(cls);
        return location != null && this.getBeanArchives().contains(location);
    }
}

