/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdiunit.internal;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;

public enum ClassLookup {
    INSTANCE;

    private final ConcurrentMap<String, AtomicReference<Class<?>>> classes = new ConcurrentHashMap();

    public <T> Class<? extends T> lookup(String className) {
        return (Class)this.classes.computeIfAbsent(className, this::lookupAbsent).get();
    }

    public boolean isPresent(String className) {
        return this.lookup(className) != null;
    }

    private AtomicReference<Class<?>> lookupAbsent(String className) {
        try {
            return new AtomicReference(Class.forName(className));
        }
        catch (ClassNotFoundException | NoClassDefFoundError throwable) {
            return new AtomicReference<Object>(null);
        }
    }
}

