/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdiunit.internal;

import io.github.cdiunit.internal.DiscoveryExtension;
import jakarta.decorator.Decorator;
import jakarta.enterprise.inject.Alternative;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.Produces;
import jakarta.enterprise.inject.Stereotype;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.interceptor.Interceptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;

public class CdiDiscoveryExtension
implements DiscoveryExtension {
    @Override
    public void bootstrap(DiscoveryExtension.BootstrapDiscoveryContext bdc) {
        bdc.discoverClass(this::discoverClass);
        bdc.discoverField(this::discoverField);
        bdc.discoverMethod(this::discoverMethod);
    }

    private void discoverClass(DiscoveryExtension.Context context, Class<?> cls) {
        this.discoverExtensions(context, cls);
        this.discoverInterceptors(context, cls);
        this.discoverDecorators(context, cls);
        this.discoverAlternativeStereotype(context, cls);
    }

    private void discoverField(DiscoveryExtension.Context context, Field field) {
        if (field.isAnnotationPresent(Inject.class) || field.isAnnotationPresent(Produces.class)) {
            context.processBean(field.getGenericType());
        }
        if (field.getType().equals(Provider.class) || field.getType().equals(Instance.class)) {
            context.processBean(field.getGenericType());
        }
    }

    private void discoverMethod(DiscoveryExtension.Context context, Method method) {
        if (method.isAnnotationPresent(Inject.class) || method.isAnnotationPresent(Produces.class)) {
            for (Type param : method.getGenericParameterTypes()) {
                context.processBean(param);
            }
            context.processBean(method.getGenericReturnType());
        }
    }

    private void discoverExtensions(DiscoveryExtension.Context context, Class<?> beanClass) {
        if (Extension.class.isAssignableFrom(beanClass) && !Modifier.isAbstract(beanClass.getModifiers())) {
            try {
                context.extension((Extension)beanClass.getConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private void discoverInterceptors(DiscoveryExtension.Context context, Class<?> beanClass) {
        if (beanClass.isAnnotationPresent(Interceptor.class)) {
            context.enableInterceptor(beanClass);
        }
    }

    private void discoverDecorators(DiscoveryExtension.Context context, Class<?> beanClass) {
        if (beanClass.isAnnotationPresent(Decorator.class)) {
            context.enableDecorator(beanClass);
        }
    }

    private void discoverAlternativeStereotype(DiscoveryExtension.Context context, Class<?> beanClass) {
        if (CdiDiscoveryExtension.isAlternativeStereotype(beanClass)) {
            context.enableAlternativeStereotype(beanClass);
        }
    }

    private static boolean isAlternativeStereotype(Class<?> c) {
        return c.isAnnotation() && c.isAnnotationPresent(Stereotype.class) && c.isAnnotationPresent(Alternative.class);
    }
}

