/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.util;

import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import java.util.Iterator;

public class GraphUtils {
    public static <D, N extends TarjanNode<D>> List<? extends List<? extends N>> tarjan(Iterable<? extends N> iterable) {
        Tarjan tarjan = new Tarjan();
        return tarjan.findSCC(iterable);
    }

    public static <D> String toDot(Iterable<? extends TarjanNode<D>> iterable, String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.format("digraph %s {\n", string));
        stringBuilder.append(String.format("label = \"%s\";\n", string2));
        for (TarjanNode<D> tarjanNode : iterable) {
            stringBuilder.append(String.format("%s [label = \"%s\"];\n", tarjanNode.hashCode(), tarjanNode.toString()));
        }
        for (TarjanNode<D> tarjanNode : iterable) {
            for (DependencyKind dependencyKind : tarjanNode.getSupportedDependencyKinds()) {
                for (TarjanNode<D> tarjanNode2 : tarjanNode.getDependenciesByKind(dependencyKind)) {
                    stringBuilder.append(String.format("%s -> %s [label = \" %s \" style = %s ];\n", tarjanNode.hashCode(), tarjanNode2.hashCode(), tarjanNode.getDependencyName(tarjanNode2, dependencyKind), dependencyKind.getDotStyle()));
                }
            }
        }
        stringBuilder.append("}\n");
        return stringBuilder.toString();
    }

    private static class Tarjan<D, N extends TarjanNode<D>> {
        int index = 0;
        ListBuffer<List<N>> sccs = new ListBuffer();
        ListBuffer<N> stack = new ListBuffer();

        private Tarjan() {
        }

        private List<? extends List<? extends N>> findSCC(Iterable<? extends N> iterable) {
            for (TarjanNode tarjanNode : iterable) {
                if (tarjanNode.index != -1) continue;
                this.findSCC(tarjanNode);
            }
            return this.sccs.toList();
        }

        private void findSCC(N n) {
            this.visitNode(n);
            Iterator iterator = ((TarjanNode)n).getAllDependencies().iterator();
            while (iterator.hasNext()) {
                TarjanNode tarjanNode;
                TarjanNode tarjanNode2 = tarjanNode = iterator.next();
                if (tarjanNode2.index == -1) {
                    this.findSCC(tarjanNode2);
                    ((TarjanNode)n).lowlink = Math.min(((TarjanNode)n).lowlink, tarjanNode2.lowlink);
                    continue;
                }
                if (!this.stack.contains(tarjanNode2)) continue;
                ((TarjanNode)n).lowlink = Math.min(((TarjanNode)n).lowlink, tarjanNode2.index);
            }
            if (((TarjanNode)n).lowlink == ((TarjanNode)n).index) {
                this.addSCC(n);
            }
        }

        private void visitNode(N n) {
            ((TarjanNode)n).index = this.index;
            ((TarjanNode)n).lowlink = this.index++;
            this.stack.prepend(n);
            ((TarjanNode)n).active = true;
        }

        private void addSCC(N n) {
            TarjanNode tarjanNode;
            ListBuffer<TarjanNode> listBuffer = new ListBuffer<TarjanNode>();
            do {
                tarjanNode = (TarjanNode)this.stack.remove();
                tarjanNode.active = false;
                listBuffer.add(tarjanNode);
            } while (tarjanNode != n);
            this.sccs.add(listBuffer.toList());
        }
    }

    public static abstract class TarjanNode<D>
    extends Node<D>
    implements Comparable<TarjanNode<D>> {
        int index = -1;
        int lowlink;
        boolean active;

        public TarjanNode(D d) {
            super(d);
        }

        @Override
        public abstract Iterable<? extends TarjanNode<D>> getAllDependencies();

        public abstract Iterable<? extends TarjanNode<D>> getDependenciesByKind(DependencyKind var1);

        @Override
        public int compareTo(TarjanNode<D> tarjanNode) {
            return this.index < tarjanNode.index ? -1 : (this.index == tarjanNode.index ? 0 : 1);
        }
    }

    public static abstract class Node<D> {
        public final D data;

        public Node(D d) {
            this.data = d;
        }

        public abstract DependencyKind[] getSupportedDependencyKinds();

        public abstract Iterable<? extends Node<D>> getAllDependencies();

        public abstract String getDependencyName(Node<D> var1, DependencyKind var2);

        public String toString() {
            return this.data.toString();
        }
    }

    public static interface DependencyKind {
        public String getDotStyle();
    }
}

