/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.sym;

import com.sun.tools.javac.util.Assert;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public abstract class Profiles {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws IOException {
        Profiles profiles = Profiles.read(new File(stringArray[0]));
        if (stringArray.length >= 2) {
            TreeMap treeMap = new TreeMap();
            for (int i = 1; i <= 4; ++i) {
                treeMap.put(i, new TreeSet());
            }
            File file = new File(stringArray[1]);
            for (String object : Files.readAllLines(file.toPath(), Charset.defaultCharset())) {
                int n;
                if (!object.endsWith(".class")) continue;
                String string = object.substring(0, object.length() - 6);
                for (int i = n = profiles.getProfile(string); i <= 4; ++i) {
                    ((Set)treeMap.get(i)).add(string);
                }
            }
            for (int i = 1; i <= 4; ++i) {
                try (BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(i + ".txt"));){
                    for (String string : (Set)treeMap.get(i)) {
                        bufferedWriter.write(string);
                        bufferedWriter.newLine();
                    }
                    continue;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Profiles read(File file) throws IOException {
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));){
            Properties properties = new Properties();
            properties.load(bufferedInputStream);
            if (properties.containsKey("java/lang/Object")) {
                SimpleProfiles simpleProfiles = new SimpleProfiles(properties);
                return simpleProfiles;
            }
            MakefileProfiles makefileProfiles = new MakefileProfiles(properties);
            return makefileProfiles;
        }
    }

    public abstract int getProfileCount();

    public abstract int getProfile(String var1);

    public abstract Set<String> getPackages(int var1);

    private static class SimpleProfiles
    extends Profiles {
        private final Map<String, Integer> map;
        private final int profileCount;

        SimpleProfiles(Properties properties) {
            int n = 0;
            this.map = new HashMap<String, Integer>();
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                String string = (String)entry.getKey();
                int n2 = Integer.valueOf((String)entry.getValue());
                this.map.put(string, n2);
                n = Math.max(n, n2);
            }
            this.profileCount = n;
        }

        @Override
        public int getProfileCount() {
            return this.profileCount;
        }

        @Override
        public int getProfile(String string) {
            return this.map.get(string);
        }

        @Override
        public Set<String> getPackages(int n) {
            TreeSet<String> treeSet = new TreeSet<String>();
            for (Map.Entry<String, Integer> entry : this.map.entrySet()) {
                String string = entry.getKey();
                int n2 = entry.getValue();
                int n3 = string.lastIndexOf("/");
                if (n3 <= 0 || n < n2) continue;
                treeSet.add(string);
            }
            return treeSet;
        }
    }

    private static class MakefileProfiles
    extends Profiles {
        final Map<String, Package> packages = new TreeMap<String, Package>();
        final int maxProfile = 4;

        MakefileProfiles(Properties properties) {
            String string;
            String string2;
            boolean bl = false;
            for (int i = 1; i <= 4 && (string2 = properties.getProperty((string = i < 4 ? "PROFILE_" + i : "FULL_JRE") + "_RTJAR_INCLUDE_PACKAGES")) != null; ++i) {
                String string3;
                for (String string4 : string2.substring(1).trim().split("\\s+")) {
                    if (string4.endsWith("/")) {
                        string4 = string4.substring(0, string4.length() - 1);
                    }
                    if (!bl && string4.equals("java/lang")) {
                        bl = true;
                    }
                    this.includePackage(i, string4);
                }
                String string5 = properties.getProperty(string + "_RTJAR_INCLUDE_TYPES");
                if (string5 != null) {
                    for (String string6 : string5.replace("$$", "$").split("\\s+")) {
                        if (!string6.endsWith(".class")) continue;
                        this.includeType(i, string6.substring(0, string6.length() - 6));
                    }
                }
                if ((string3 = properties.getProperty(string + "_RTJAR_EXCLUDE_TYPES")) == null) continue;
                for (String string7 : string3.replace("$$", "$").split("\\s+")) {
                    if (!string7.endsWith(".class")) continue;
                    this.excludeType(i, string7.substring(0, string7.length() - 6));
                }
            }
            if (bl) {
                this.includePackage(1, "javax/crypto");
            }
        }

        @Override
        public int getProfileCount() {
            return 4;
        }

        @Override
        public int getProfile(String string) {
            int n = string.lastIndexOf("/");
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            Package package_ = this.getPackage(string2);
            return package_.getProfile(string3);
        }

        @Override
        public Set<String> getPackages(int n) {
            TreeSet<String> treeSet = new TreeSet<String>();
            for (Package package_ : this.packages.values()) {
                package_.getPackages(n, treeSet);
            }
            return treeSet;
        }

        private void includePackage(int n, String string) {
            Package package_ = this.getPackage(string);
            Assert.check(package_.profile == 0);
            package_.profile = n;
        }

        private void includeType(int n, String string) {
            int n2 = string.lastIndexOf("/");
            String string2 = string.substring(0, n2);
            String string3 = string.substring(n2 + 1);
            Package package_ = this.getPackage(string2);
            Assert.check(!package_.includedTypes.containsKey(string3));
            package_.includedTypes.put(string3, n);
        }

        private void excludeType(int n, String string) {
            int n2 = string.lastIndexOf("/");
            String string2 = string.substring(0, n2);
            String string3 = string.substring(n2 + 1);
            Package package_ = this.getPackage(string2);
            Assert.check(!package_.excludedTypes.containsKey(string3));
            package_.excludedTypes.put(string3, n);
        }

        private Package getPackage(String string) {
            String string2;
            Map<String, Package> map;
            Package package_;
            int n = string.lastIndexOf("/");
            if (n == -1) {
                package_ = null;
                map = this.packages;
                string2 = string;
            } else {
                package_ = this.getPackage(string.substring(0, n));
                map = package_.subpackages;
                string2 = string.substring(n + 1);
            }
            Package package_2 = map.get(string2);
            if (package_2 == null) {
                package_2 = new Package(package_, string2);
                map.put(string2, package_2);
            }
            return package_2;
        }

        static class Package {
            final Package parent;
            final String name;
            Map<String, Package> subpackages = new TreeMap<String, Package>();
            int profile;
            Map<String, Integer> includedTypes = new TreeMap<String, Integer>();
            Map<String, Integer> excludedTypes = new TreeMap<String, Integer>();

            Package(Package package_, String string) {
                this.parent = package_;
                this.name = string;
            }

            int getProfile() {
                return this.parent == null ? this.profile : Math.max(this.parent.getProfile(), this.profile);
            }

            int getProfile(String string) {
                Integer n = this.includedTypes.get(string);
                if (n != null) {
                    return n;
                }
                n = this.includedTypes.get("*");
                if (n != null) {
                    return n;
                }
                n = this.excludedTypes.get(string);
                if (n != null) {
                    return n + 1;
                }
                n = this.excludedTypes.get("*");
                if (n != null) {
                    return n + 1;
                }
                return this.getProfile();
            }

            String getName() {
                return this.parent == null ? this.name : this.parent.getName() + "/" + this.name;
            }

            void getPackages(int n, Set<String> set) {
                int n2 = this.getProfile();
                if (n2 != 0 && n >= n2) {
                    set.add(this.getName());
                }
                for (Package package_ : this.subpackages.values()) {
                    package_.getPackages(n, set);
                }
            }
        }
    }
}

