/*
 * Decompiled with CFR 0.152.
 */
package com.bw.jtools.reports.html;

import com.bw.jtools.reports.ReportRenderer;
import com.bw.jtools.reports.TextOptions;

public class HtmlRenderer
extends ReportRenderer {
    StringBuilder sb = new StringBuilder(1000);
    int reloadTimeS = 0;

    public void setReloadTime(int seconds) {
        this.reloadTimeS = seconds;
    }

    public void addEscaped(String text) {
        char[] data;
        block8: for (char c : data = text.toCharArray()) {
            switch (c) {
                case '<': {
                    this.sb.append("&lt;");
                    continue block8;
                }
                case '>': {
                    this.sb.append("&gt;");
                    continue block8;
                }
                case '&': {
                    this.sb.append("&amp;");
                    continue block8;
                }
                case '\"': {
                    this.sb.append("&quot;");
                    continue block8;
                }
                case '\'': {
                    this.sb.append("&apos;");
                    continue block8;
                }
                case '\n': {
                    this.sb.append("<br/>");
                    continue block8;
                }
                default: {
                    this.sb.append(c);
                }
            }
        }
    }

    @Override
    public void startParagraph() {
        this.sb.append("<p>");
    }

    @Override
    public void endParagraph() {
        this.sb.append("</p>");
    }

    @Override
    public void addText(String text) {
        this.addEscaped(text);
    }

    @Override
    public void addText(String text, TextOptions options) {
        if (options.bold) {
            this.sb.append("<b>");
        }
        if (options.italic) {
            this.sb.append("<i>");
        }
        this.addText(text);
        if (options.italic) {
            this.sb.append("</i>");
        }
        if (options.bold) {
            this.sb.append("</b>");
        }
    }

    @Override
    public void startTable() {
        this.sb.append("<table>");
    }

    @Override
    public void startRow() {
        this.sb.append("<tr>");
    }

    @Override
    public void startCell(int spans) {
        if (spans <= 1) {
            this.sb.append("<td>");
        } else {
            this.sb.append("<td colspan=\"");
            this.sb.append(Integer.toString(spans));
            this.sb.append("\">");
        }
    }

    @Override
    public void endCell() {
        this.sb.append("</td>");
    }

    @Override
    public void endRow() {
        this.sb.append("</tr>");
    }

    @Override
    public void endTable() {
        this.sb.append("</table>");
    }

    @Override
    public void startDocument(String title) {
        this.sb.setLength(0);
        if (title == null) {
            title = "";
        }
        this.sb.append("<html><head><meta charset=\"utf-8\">");
        if (this.reloadTimeS > 0) {
            this.sb.append("<meta http-equiv=\"refresh\" content=\"");
            this.sb.append(this.reloadTimeS);
            this.sb.append("\"/>");
        }
        this.sb.append("<title>");
        this.addEscaped(title);
        this.sb.append(title);
        this.sb.append("</title>");
        this.sb.append("<style>table{width:100%;border:1px solid black;border-collapse:collapse;} th,td{border:1px solid black;text-align:left;vertical-align:top;}tr:hover{background-color:#f5f5f5;}</style>");
        this.sb.append("<body>");
    }

    @Override
    public void endDocument() {
        this.sb.append("</body></html>");
    }

    public String toString() {
        return this.sb.toString();
    }

    @Override
    public void startTableHead() {
        this.sb.append("<thead>");
    }

    @Override
    public void endTableHead() {
        this.sb.append("</thead>");
    }
}

