/*
 * Decompiled with CFR 0.152.
 */
package com.bw.jtools.persistence;

import com.bw.jtools.Application;
import com.bw.jtools.Log;
import com.bw.jtools.persistence.FileStorage;
import com.bw.jtools.persistence.MissingPropertyException;
import com.bw.jtools.persistence.PreferencesStorage;
import com.bw.jtools.persistence.StorageBase;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Store {
    public static String DEFAULT_INI = "defaultsettings.properties";
    public static String KEY_APPLICATION_NAME = "application.name";
    public static String KEY_APPLICATION_BASEDIR = "application.basedir";
    public static String KEY_APPLICATION_COMPANY = "application.company";
    public static String KEY_APPLICATION_ICON_PREFIX = "application.iconPrefix";
    public static String KEY_APPLICATION_LOG_LEVEL = "application.loglevel";
    public static String KEY_APPLICATION_PROPERTIES_FILE = "application.properties";
    public static String KEY_APPLICATION_VERSION = "application.version";
    private static StorageBase storage_;
    public static String AppPropertyFile;

    private static String resolveFromDefaults(String value, Properties defaults) {
        Pattern p = Pattern.compile("%([^%]*)%");
        Matcher m = p.matcher(value);
        StringBuilder newPF = new StringBuilder(20);
        int lindex = 0;
        while (m.find()) {
            newPF.append(value.substring(lindex, m.start(0)));
            String propValue = defaults.getProperty(m.group(1));
            if (propValue != null) {
                newPF.append(propValue);
            }
            lindex = m.end(0);
        }
        if (lindex > 0) {
            if (lindex < value.length()) {
                newPF.append(value.substring(lindex));
            }
            if (Log.isDebugEnabled()) {
                Log.debug("Value '" + value + "' resolved to '" + newPF + "'");
            }
            return newPF.toString();
        }
        return value;
    }

    public static void initialize(boolean useSysPropsForDefault) {
        Properties defaults = useSysPropsForDefault ? new Properties(System.getProperties()) : new Properties();
        String appName = null;
        String company = null;
        String propFile = null;
        String version = null;
        String appIconPrefix = null;
        String appLogLevel = null;
        String appBaseDir = null;
        try {
            InputStream is = Application.AppClass.getResourceAsStream(DEFAULT_INI);
            if (is != null) {
                defaults.load(is);
                is.close();
            }
            appName = defaults.getProperty(KEY_APPLICATION_NAME);
            company = defaults.getProperty(KEY_APPLICATION_COMPANY);
            propFile = defaults.getProperty(KEY_APPLICATION_PROPERTIES_FILE);
            version = defaults.getProperty(KEY_APPLICATION_VERSION);
            appIconPrefix = defaults.getProperty(KEY_APPLICATION_ICON_PREFIX);
            appLogLevel = defaults.getProperty(KEY_APPLICATION_LOG_LEVEL);
            appBaseDir = defaults.getProperty(KEY_APPLICATION_BASEDIR);
        }
        catch (IOException is) {
            // empty catch block
        }
        if (appName != null && appName.isEmpty()) {
            appName = null;
        }
        if (company != null && company.isEmpty()) {
            company = null;
        }
        if (propFile != null && propFile.isEmpty()) {
            propFile = null;
        }
        if (appIconPrefix != null && appIconPrefix.isEmpty()) {
            appIconPrefix = null;
        }
        if (appBaseDir != null && appBaseDir.isEmpty()) {
            appBaseDir = null;
        }
        if (appLogLevel != null) {
            int level = -1;
            if ("NONE".equalsIgnoreCase(appLogLevel)) {
                level = 0;
            } else if ("ERROR".equalsIgnoreCase(appLogLevel)) {
                level = 1;
            } else if ("WARN".equalsIgnoreCase(appLogLevel)) {
                level = 2;
            } else if ("INFO".equalsIgnoreCase(appLogLevel)) {
                level = 3;
            } else if ("DEBUG".equalsIgnoreCase(appLogLevel)) {
                level = 4;
            } else {
                try {
                    level = Integer.parseUnsignedInt(appLogLevel);
                }
                catch (Exception e) {
                    Log.error(KEY_APPLICATION_LOG_LEVEL + ": have to be NONE, ERROR, WARN, INFO, DEBUG or a positive integer.");
                }
            }
            if (level > -1) {
                Log.setLevel(level);
            }
        }
        if (appName == null) {
            Log.warn("Property '" + KEY_APPLICATION_NAME + "' is not set, please check " + DEFAULT_INI);
            appName = Application.AppClass != null ? Application.AppClass.getSimpleName() : "MyApp";
        }
        if (company == null) {
            int nextDot;
            int firstDot;
            String fullname;
            if (Application.AppClass != null && (fullname = Application.AppClass.getPackage().getName()) != null && (firstDot = fullname.indexOf(46)) > 0 && (nextDot = fullname.indexOf(46, firstDot + 1)) > 0) {
                company = fullname.substring(firstDot + 1, nextDot);
            }
            if (company == null || company.isEmpty()) {
                company = "MyCompany";
            }
        }
        if (version == null) {
            version = "1.0";
        }
        if (appIconPrefix == null) {
            appIconPrefix = appName;
        }
        Application.AppName = appName;
        Application.AppVersion = version;
        Application.AppCompany = company;
        Application.AppIconPrefix = appIconPrefix;
        Path appBaseFolder = null;
        try {
            if (appBaseDir == null) {
                URL codeLocation = Application.AppClass.getProtectionDomain().getCodeSource().getLocation();
                if (codeLocation != null) {
                    appBaseFolder = Paths.get(codeLocation.toURI()).toRealPath(new LinkOption[0]);
                }
            } else {
                appBaseDir = Store.resolveFromDefaults(appBaseDir, defaults);
                appBaseFolder = Paths.get(appBaseDir, new String[0]);
            }
            if (appBaseFolder != null) {
                if (!Files.exists(appBaseFolder, new LinkOption[0])) {
                    Log.warn("Creating none existing application base directory " + appBaseFolder);
                    Files.createDirectories(appBaseFolder, new FileAttribute[0]);
                } else if (!Files.isDirectory(appBaseFolder, new LinkOption[0]) && !Files.isDirectory(appBaseFolder = appBaseFolder.getParent(), new LinkOption[0])) {
                    appBaseFolder = null;
                }
                if (appBaseFolder != null && !Files.isWritable(appBaseFolder)) {
                    Log.warn("No write permissions to application base directory " + appBaseFolder);
                }
            }
        }
        catch (Exception se) {
            Log.warn("Failed to access application base directory", se);
            appBaseFolder = null;
        }
        Application.setBaseAppDirectory(appBaseFolder);
        Path p = Application.getBaseAppDirectory();
        if (p != null) {
            defaults.put(KEY_APPLICATION_BASEDIR, p.toString());
        }
        if (propFile != null) {
            propFile = Store.resolveFromDefaults(propFile, defaults);
        }
        AppPropertyFile = propFile;
        PreferencesStorage.PREF_ROOT_KEY = company + "/" + appName;
        Path propPath = null;
        if (AppPropertyFile != null) {
            try {
                propPath = Paths.get(AppPropertyFile, new String[0]);
                if (!propPath.isAbsolute()) {
                    propPath = Application.getBaseAppDirectory().resolve(propPath);
                }
                storage_ = new FileStorage(propPath, defaults);
            }
            catch (Exception e) {
                Log.debug("Failed to use preferences from " + propPath, e);
            }
        }
        if (storage_ == null) {
            storage_ = new PreferencesStorage(defaults);
        }
    }

    private static void transferStorage(StorageBase newStorage) {
        newStorage.clear();
        List<String> keys = storage_.getKeysWithPrefix("");
        for (String key : keys) {
            newStorage.setString(key, storage_.getString(key, null));
        }
        storage_ = newStorage;
    }

    public static void enablePreferences(boolean enable) {
        if (Store.isPreferencesEnabled() != enable) {
            if (enable) {
                Store.transferStorage(new PreferencesStorage(storage_ == null ? null : storage_.getDefaults()));
            } else {
                StorageBase old = storage_;
                Store.transferStorage(new FileStorage(Application.getBaseAppDirectory().resolve(AppPropertyFile), storage_ == null ? null : storage_.getDefaults()));
                old.clear();
            }
        }
    }

    public static boolean isPreferencesEnabled() {
        return storage_ instanceof PreferencesStorage;
    }

    public static void createBaseAppDirectory() {
        Path baseAppDataPath = Application.getBaseAppDirectory();
        try {
            if (!Files.exists(baseAppDataPath, new LinkOption[0])) {
                Files.createDirectory(baseAppDataPath, new FileAttribute[0]);
            }
        }
        catch (Exception e) {
            Log.error("Failed to create data directory '" + baseAppDataPath.toString() + "'. " + e.getMessage());
        }
        if (!Files.isDirectory(baseAppDataPath, new LinkOption[0]) || !Files.isWritable(baseAppDataPath)) {
            Log.error("Can't access data directory '" + baseAppDataPath.toString() + "'");
        }
    }

    public static String getString(String key) throws MissingPropertyException {
        return storage_.getString(key);
    }

    public static String getString(String key, String def) {
        return storage_.getString(key, def);
    }

    public static double getDouble(String key, double def) {
        return storage_.getDouble(key, def);
    }

    public static void setDouble(String key, double value) {
        storage_.setDouble(key, value);
    }

    public static int getInt(String key, int def) {
        return storage_.getInt(key, def);
    }

    public static void setInt(String key, int value) {
        storage_.setInt(key, value);
    }

    public static boolean getBoolean(String key, boolean def) {
        return storage_.getBoolean(key, def);
    }

    public static void setBoolean(String key, boolean value) {
        storage_.setBoolean(key, value);
    }

    public static void setString(String key, String value) {
        storage_.setString(key, value);
    }

    public static List<String> getKeysWithPrefix(String prefix) {
        return storage_.getKeysWithPrefix(prefix);
    }

    public static void copyIfNotSet(String keyFrom, String keyTo) {
        String pref;
        if (Store.getString(keyTo, null) == null && (pref = Store.getString(keyFrom, null)) != null) {
            Store.setString(keyTo, pref);
        }
    }

    public static void deleteKey(String key) {
        storage_.deleteKey(key);
    }

    public static void flushStorage() {
        storage_.flush();
    }
}

