/*
 * Decompiled with CFR 0.152.
 */
package com.bw.jtools.persistence;

import com.bw.jtools.Application;
import com.bw.jtools.Log;
import com.bw.jtools.persistence.StorageBase;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

class FileStorage
extends StorageBase {
    private final Path path_;
    private final HashMap<String, String> values_ = new HashMap();
    private boolean dirty_ = false;
    private boolean loaded_ = false;

    public FileStorage(Path storageFile, Properties defaults) {
        super(defaults);
        this.path_ = storageFile;
    }

    private void loadIfNeeded() {
        if (!this.loaded_) {
            this.loaded_ = true;
            try (BufferedReader reader = Files.newBufferedReader(this.path_);){
                reader.lines().forEach(line -> {
                    String key;
                    int pos;
                    if (!(line = line.trim()).startsWith("#") && (pos = line.indexOf(61)) > 0 && !this.values_.containsKey(key = line.substring(0, pos).trim())) {
                        this.values_.put(key, line.substring(pos + 1).trim());
                    }
                });
            }
            catch (Exception e) {
                Log.error("Failed to read settings: " + e.getMessage());
            }
        }
    }

    @Override
    protected synchronized String getString_impl(String key) {
        this.loadIfNeeded();
        return this.values_.get(key);
    }

    @Override
    public synchronized void setString(String key, String value) {
        if (this.values_.containsKey(key)) {
            String oldVal = this.values_.get(key);
            if (value == null ? oldVal == null : value.equals(oldVal)) {
                return;
            }
        }
        this.values_.put(key, value);
        this.dirty_ = true;
    }

    @Override
    public synchronized void deleteKey(String key) {
        if (this.loaded_) {
            if (this.values_.containsKey(key) && this.values_.get(key) != null) {
                this.dirty_ = true;
                this.values_.put(key, null);
            }
        } else {
            this.dirty_ = true;
            this.values_.put(key, null);
        }
    }

    @Override
    public synchronized void clear() {
        this.dirty_ = false;
        this.values_.clear();
        try {
            if (Files.exists(this.path_, new LinkOption[0])) {
                Files.delete(this.path_);
            }
        }
        catch (Exception e) {
            Log.error(e.getMessage());
        }
    }

    @Override
    public synchronized void flush() {
        if (this.dirty_) {
            this.loadIfNeeded();
            try {
                ArrayList<String> keys = new ArrayList<String>(this.values_.size());
                keys.addAll(this.values_.keySet());
                Collections.sort(keys);
                try (BufferedWriter writer = Files.newBufferedWriter(this.path_, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);){
                    writer.write("# " + Application.AppName + " Settings\n");
                    for (String k : keys) {
                        String value = this.values_.get(k);
                        if (value == null) continue;
                        writer.write(k);
                        writer.write("=");
                        writer.write(value);
                        writer.write("\n");
                    }
                }
                this.dirty_ = false;
            }
            catch (Exception e) {
                Log.error(e.getMessage());
            }
        }
    }

    @Override
    public synchronized List<String> getKeysWithPrefix(String prefix) {
        this.loadIfNeeded();
        ArrayList<String> l = new ArrayList<String>();
        for (Map.Entry<String, String> entry : this.values_.entrySet()) {
            if (entry.getValue() == null || !entry.getKey().startsWith(prefix)) continue;
            l.add(entry.getKey());
        }
        return l;
    }
}

