/*
 * The MIT License
 *
 * Copyright 2020 Bernd Wengenroth.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package com.bw.jtools.profiling.weaving;

import com.bw.jtools.profiling.MethodProfiling;
import net.bytebuddy.asm.Advice;

/**
 * Advice for use with Byte Buddy.
 * This advice is not usable for c'tors as ByteBuddy currently doesn't support
 * cathing exceptions in C'tors.
 */
public final class ByteBuddyProfilingThrowAdvice
{

    @Advice.OnMethodEnter(inline = true)
    static public void adviceEnter(
            @Advice.Origin("#t") String clazz,
            @Advice.Origin("#m") String method,
            @Advice.Local("$MP$") MethodProfiling mp)
    {
        mp = new MethodProfiling(clazz, method);
    }

    @Advice.OnMethodExit(inline = true, onThrowable = Throwable.class)
    static public void adviceExitThrown(@Advice.Local("$MP$") MethodProfiling mp, @Advice.Thrown Throwable thrown)
    {
        if (mp != null )
        {
            if ( thrown != null ) mp.exception(thrown);
            mp.close();
        }
    }

}
