/*
 * Decompiled with CFR 0.152.
 */
package kr.co.bootpay.android.constants;

import android.content.Context;
import androidx.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import kr.co.bootpay.android.models.Payload;
import kr.co.bootpay.android.pref.UserInfo;

public class BootpayConstant {
    public static final String CDN_URL = "https://webview.bootpay.co.kr/4.0.7";
    public static final int REQUEST_TYPE_PAYMENT = 1;
    public static final int REQUEST_TYPE_SUBSCRIPT = 2;
    public static final int REQUEST_TYPE_AUTH = 3;

    public static final String getJSPay(@Nullable Payload payload, int requestType) {
        if (payload == null) {
            return "";
        }
        String requestMethod = "requestPayment";
        if (requestType == 1) {
            requestMethod = "requestPayment";
        } else if (requestType == 2) {
            requestMethod = "requestSubscription";
            if ("".equals(payload.getSubscriptionId())) {
                payload.setSubscriptionId(payload.getOrderId());
            }
        } else if (requestType == 3) {
            requestMethod = "requestAuthentication";
            if ("".equals(payload.getAuthenticationId())) {
                payload.setAuthenticationId(payload.getOrderId());
            }
        }
        return BootpayConstant.loadParams("Bootpay." + requestMethod + "(", payload.toJsonUnderscore(), ")", ".then( function (res) {", BootpayConstant.confirm(), BootpayConstant.issued(), BootpayConstant.done(), "}, function (res) {", BootpayConstant.error(), BootpayConstant.cancel(), "})");
    }

    public static String loadParams(String ... script) {
        StringBuilder builder = new StringBuilder();
        for (String s : script) {
            builder.append(s);
        }
        builder.append(";");
        return builder.toString();
    }

    public static String confirm() {
        return "if (res.event === 'confirm') { Android.confirm(JSON.stringify(res)); }";
    }

    public static String done() {
        return "else if (res.event === 'done') { Android.done(JSON.stringify(res)); }";
    }

    public static String issued() {
        return "else if (res.event === 'issued') { Android.issued(JSON.stringify(res)); }";
    }

    public static String error() {
        return "if (res.event === 'error') { Android.error(JSON.stringify(res)); }";
    }

    public static String cancel() {
        return "else if (res.event === 'cancel') { Android.cancel(JSON.stringify(res)); }";
    }

    public static String close() {
        return "document.addEventListener('bootpayclose', function (e) { Bootpay.close('\uacb0\uc81c\ucc3d\uc774 \ub2eb\ud614\uc2b5\ub2c8\ub2e4'); });";
    }

    public static String message() {
        return "document.addEventListener('message', function (e) { Android.message(JSON.stringify(e)); });";
    }

    public static final List<String> getJSBeforePayStart(Context context) {
        ArrayList<String> scripts = new ArrayList<String>();
        scripts.add("Bootpay.setVersion('4.0.8', 'android');");
        scripts.add("Bootpay.setDevice('ANDROID');");
        scripts.add(BootpayConstant.getAnalyticsData(context));
        scripts.add(BootpayConstant.close());
        return scripts;
    }

    private static String getAnalyticsData(Context context) {
        return String.format(Locale.KOREA, "Bootpay.setAnalyticsData({uuid:'%s',sk:'%s',sk_time:'%d',time:'%d'});", UserInfo.getInstance(context).getBootpayUuid(), UserInfo.getInstance(context).getBootpaySk(), UserInfo.getInstance(context).getBootpayLastTime(), System.currentTimeMillis() - UserInfo.getInstance(context).getBootpayLastTime());
    }
}

