/*
 * Decompiled with CFR 0.152.
 */
package kr.co.bootpay.android.pref;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.AsyncTask;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.pddstudio.preferences.encrypted.EncryptedPreferences;
import java.util.Locale;
import java.util.UUID;

public class UserInfo {
    private static Context context;
    private final String encryptPassword = "1q2w3e4r";
    private static UserInfo instance;
    private EncryptedPreferences encryptedPreferences;

    private UserInfo() {
    }

    public void setContext(Context context) {
        UserInfo.context = context;
    }

    public static UserInfo getInstance(Context context) {
        if (instance == null) {
            instance = new UserInfo();
            UserInfo.instance.encryptedPreferences = new EncryptedPreferences.Builder(context).withEncryptionPassword(UserInfo.instance.encryptPassword).build();
        }
        return instance;
    }

    public String getBootpayUuid() {
        String value = UserInfo.instance.encryptedPreferences.getString("bootpay_uuid", "");
        if (value == null || value.isEmpty()) {
            value = UUID.randomUUID().toString();
            this.setBootpayUuid(value);
        }
        return value;
    }

    public void setBootpayUuid(String bootpay_uuid) {
        UserInfo.instance.encryptedPreferences.edit().putString("bootpay_uuid", bootpay_uuid).apply();
    }

    public Long getBootpayLastTime() {
        return UserInfo.instance.encryptedPreferences.getLong("bootpay_last_time", System.currentTimeMillis());
    }

    public void setBootpayLastTime(Long bootpay_last_time) {
        UserInfo.instance.encryptedPreferences.edit().putLong("bootpay_last_time", bootpay_last_time.longValue()).apply();
    }

    public String getBootpaySk() {
        return UserInfo.instance.encryptedPreferences.getString("bootpay_sk", "");
    }

    public void setBootpaySk(String bootpay_sk) {
        UserInfo.instance.encryptedPreferences.edit().putString("bootpay_sk", bootpay_sk).apply();
    }

    public void newSk(Long time) {
        UserInfo.instance.encryptedPreferences.edit().putString("bootpay_sk", String.format(Locale.KOREA, "%s_%d", this.getBootpayUuid(), time)).apply();
    }

    public String getBootpayApplicationId() {
        return UserInfo.instance.encryptedPreferences.getString("bootpay_application_id", "");
    }

    public void setBootpayApplicationId(String bootpay_application_id) {
        UserInfo.instance.encryptedPreferences.edit().putString("bootpay_application_id", bootpay_application_id).apply();
    }

    public String getBootpayUserId() {
        return UserInfo.instance.encryptedPreferences.getString("bootpay_user_id", "");
    }

    public void setBootpayUserId(String bootpay_user_id) {
        UserInfo.instance.encryptedPreferences.edit().putString("bootpay_user_id", bootpay_user_id).apply();
    }

    public String getBootpay_receipt_id() {
        return UserInfo.instance.encryptedPreferences.getString("bootpay_receipt_id", "");
    }

    public void setBootpay_receipt_id(String bootpay_receipt_id) {
        UserInfo.instance.encryptedPreferences.edit().putString("bootpay_receipt_id", bootpay_receipt_id).apply();
    }

    public String getDeveloperPayload() {
        return UserInfo.instance.encryptedPreferences.getString("developerPayload", "");
    }

    public void setDeveloperPayload(String developerPayload) {
        UserInfo.instance.encryptedPreferences.edit().putString("developerPayload", developerPayload).apply();
    }

    public Boolean getEnableOneStore() {
        return UserInfo.instance.encryptedPreferences.getBoolean("enable_one_store", false);
    }

    public void setEnableOneStore(Boolean enable_onstore) {
        UserInfo.instance.encryptedPreferences.edit().putBoolean("enable_onstore", enable_onstore.booleanValue()).apply();
    }

    private static String getSimOperator(Context context) {
        Context applicationContext;
        TelephonyManager telephonyManager;
        if (context != null && (telephonyManager = (TelephonyManager)(applicationContext = context.getApplicationContext()).getSystemService("phone")) != null && telephonyManager.getSimState() == 5) {
            return telephonyManager.getSimOperator();
        }
        return "UNKNOWN_SIM_OPERATOR";
    }

    public void setSimOperator(String sim_operator) {
        UserInfo.instance.encryptedPreferences.edit().putString("sim_operator", sim_operator).apply();
    }

    private static String getInstallerPackageName(Context context) {
        Context applicationContext;
        PackageManager pm;
        String installPackageName;
        if (context != null && !TextUtils.isEmpty((CharSequence)(installPackageName = (pm = (applicationContext = context.getApplicationContext()).getPackageManager()).getInstallerPackageName(applicationContext.getPackageName())))) {
            return installPackageName;
        }
        return "UNKNOWN_INSTALLER";
    }

    public void setInstallPackageMarket(String install_package_market) {
        UserInfo.instance.encryptedPreferences.edit().putString("install_package_market", install_package_market).apply();
    }

    public String getAdId() {
        return UserInfo.instance.encryptedPreferences.getString("ad_id", "");
    }

    public static void UseOneStoreApi(Context context, Boolean enable) {
        UserInfo.context = context;
        if (!enable.booleanValue()) {
            UserInfo.getInstance(context).setEnableOneStore(enable);
            return;
        }
        UserInfo.getInstance(context).update();
        UserInfo.getInstance(context).setEnableOneStore(enable);
        UserInfo.getInstance(context).setInstallPackageMarket(UserInfo.getInstallerPackageName(context));
        UserInfo.getInstance(context).setSimOperator(UserInfo.getSimOperator(context));
        new GoogleAppIdTask().execute(new Void[0]);
    }

    public void setAdId(String ad_id) {
        UserInfo.instance.encryptedPreferences.edit().putString("ad_id", ad_id).apply();
    }

    public void update() {
        Long current;
        boolean isExipred;
        if (this.getBootpayUuid().isEmpty()) {
            this.setBootpayUuid(UUID.randomUUID().toString());
        }
        if (this.getBootpaySk().isEmpty()) {
            this.setBootpaySk(String.format(Locale.KOREA, "%s_%d", this.getBootpayUuid(), this.getBootpayLastTime()));
        }
        boolean bl = isExipred = (current = Long.valueOf(System.currentTimeMillis())) - this.getBootpayLastTime() > 1800000L;
        if (isExipred) {
            this.newSk(current);
        }
        this.setBootpayLastTime(current);
    }

    public void finish() {
        this.setBootpayLastTime(System.currentTimeMillis());
    }

    public String getUUID() {
        return UserInfo.instance.encryptedPreferences.getString("uuid", "");
    }

    public void setBiometricSecretKey(String value) {
        UserInfo.instance.encryptedPreferences.edit().putString("biometric_secret_key", value).apply();
    }

    public void setBiometricDeviceId(String value) {
        UserInfo.instance.encryptedPreferences.edit().putString("biometric_device_id", value).apply();
    }

    public String getBiometricSecretKey() {
        return UserInfo.instance.encryptedPreferences.getString("biometric_secret_key", "");
    }

    public String getBiometricDeviceId() {
        return UserInfo.instance.encryptedPreferences.getString("biometric_device_id", "");
    }

    private static class GoogleAppIdTask
    extends AsyncTask<Void, Void, String> {
        private GoogleAppIdTask() {
        }

        protected String doInBackground(Void ... params) {
            if (context == null) {
                return "UNKNOWN_ADID";
            }
            try {
                return AdvertisingIdClient.getAdvertisingIdInfo((Context)context).getId();
            }
            catch (IllegalStateException ex) {
                ex.printStackTrace();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return "UNKNOWN_ADID";
        }

        protected void onPostExecute(String adId) {
            if (context == null) {
                return;
            }
            UserInfo.getInstance(context).setAdId(adId);
        }
    }
}

