/*
 * Decompiled with CFR 0.152.
 */
package kr.co.bootpay.android.api;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.os.Handler;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Toast;
import androidx.annotation.Nullable;
import androidx.fragment.app.DialogFragment;
import androidx.fragment.app.FragmentManager;
import kr.co.bootpay.android.api.BootpayDialogInterface;
import kr.co.bootpay.android.api.BootpayInterface;
import kr.co.bootpay.android.constants.BootpayConstant;
import kr.co.bootpay.android.events.BootpayEventListener;
import kr.co.bootpay.android.models.Payload;
import kr.co.bootpay.android.webview.BootpayWebView;

public class BootpayDialogX
extends DialogFragment
implements BootpayDialogInterface,
BootpayInterface {
    BootpayWebView mWebView = null;
    Payload mPayload = null;
    BootpayEventListener mEventListener = null;
    boolean doubleBackToExitPressedOnce = false;
    private int mRequestType = 1;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setStyle(2, 16973934);
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, Bundle savedInstanceState) {
        if (this.mWebView == null) {
            this.mWebView = new BootpayWebView(inflater.getContext());
        }
        if (this.mEventListener != null) {
            this.mWebView.setEventListener(this.mEventListener);
        }
        if (this.mPayload != null) {
            this.mWebView.setInjectedJS(BootpayConstant.getJSPay(this.mPayload, this.mRequestType));
            this.mWebView.setPayload(this.mPayload);
        }
        this.mWebView.setInjectedJSBeforePayStart(BootpayConstant.getJSBeforePayStart(this.getContext()));
        this.backButtonEventBind();
        this.mWebView.startBootpay();
        return this.mWebView;
    }

    void backButtonEventBind() {
        Dialog dialog = this.getDialog();
        dialog.setOnKeyListener(new DialogInterface.OnKeyListener(){

            public boolean onKey(DialogInterface dialogInterface, int keyCode, KeyEvent keyEvent) {
                if (keyEvent.getAction() != 0) {
                    return true;
                }
                if (keyCode == 4) {
                    if (BootpayDialogX.this.doubleBackToExitPressedOnce) {
                        BootpayEventListener listener = BootpayDialogX.this.mWebView.getEventListener();
                        if (listener != null) {
                            listener.onClose("\uc0ac\uc6a9\uc790\uac00 \ucc3d\uc744 \ub2eb\uc558\uc2b5\ub2c8\ub2e4");
                        }
                        return true;
                    }
                    BootpayDialogX.this.doubleBackToExitPressedOnce = true;
                    Toast.makeText((Context)BootpayDialogX.this.getContext(), (CharSequence)"\uacb0\uc81c\ub97c \uc885\ub8cc\ud558\uc2dc\ub824\uba74 '\ub4a4\ub85c' \ubc84\ud2bc\uc744 \ud55c\ubc88 \ub354 \ub20c\ub7ec\uc8fc\uc138\uc694.", (int)0).show();
                    new Handler().postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            BootpayDialogX.this.doubleBackToExitPressedOnce = false;
                        }
                    }, 2000L);
                }
                return false;
            }
        });
    }

    public Payload getPayload() {
        return this.mPayload;
    }

    public void requestPayment(FragmentManager fragmentManager) throws IllegalArgumentException {
        if (this.mPayload == null) {
            throw new IllegalArgumentException("payload\ub294 null \uc774 \ub420 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.");
        }
        this.mRequestType = 1;
        this.show(fragmentManager, this.mPayload.getOrderId());
    }

    public void requestSubscription(FragmentManager fragmentManager) throws IllegalArgumentException {
        if (this.mPayload == null) {
            throw new IllegalArgumentException("payload\ub294 null \uc774 \ub420 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.");
        }
        this.mRequestType = 2;
        this.show(fragmentManager, this.mPayload.getOrderId());
    }

    public void requestAuthentication(FragmentManager fragmentManager) throws IllegalArgumentException {
        if (this.mPayload == null) {
            throw new IllegalArgumentException("payload\ub294 null \uc774 \ub420 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.");
        }
        this.mRequestType = 3;
        this.show(fragmentManager, this.mPayload.getOrderId());
    }

    @Override
    public void removePaymentWindow() {
        if (this.mWebView != null) {
            this.mWebView.removePaymentWindow();
        }
        this.dismiss();
    }

    @Override
    public void setEventListener(BootpayEventListener listener) {
        this.mEventListener = listener;
    }

    @Override
    public void setPayload(Payload payload) {
        this.mPayload = payload;
    }

    public void transactionConfirm(String data) {
        if (this.mWebView != null) {
            this.mWebView.transactionConfirm(data);
        }
    }
}

