/*
 * Decompiled with CFR 0.152.
 */
package kr.co.bootpay.android.analytics;

import android.content.Context;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import kr.co.bootpay.android.analytics.LoginResult;
import kr.co.bootpay.android.cookiejar.PersistentCookieJar;
import kr.co.bootpay.android.cookiejar.cache.SetCookieCache;
import kr.co.bootpay.android.cookiejar.persistence.SharedPrefsCookiePersistor;
import okhttp3.CookieJar;
import okhttp3.OkHttpClient;
import retrofit2.Call;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;
import retrofit2.converter.gson.GsonConverterFactory;
import retrofit2.http.Field;
import retrofit2.http.FormUrlEncoded;
import retrofit2.http.POST;

public class AnalyticsService {
    private Context context;
    private AnalyticsRestApi api;

    public AnalyticsService(Context context) {
        this.context = context;
        OkHttpClient client = new OkHttpClient.Builder().cookieJar((CookieJar)new PersistentCookieJar(new SetCookieCache(), new SharedPrefsCookiePersistor(context))).build();
        Gson gson = new GsonBuilder().setLenient().create();
        this.api = (AnalyticsRestApi)new Retrofit.Builder().baseUrl("https://analytics.bootpay.co.kr").client(client).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create()).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)gson)).build().create(AnalyticsRestApi.class);
    }

    public Context getContext() {
        return this.context;
    }

    public AnalyticsRestApi getApi() {
        return this.api;
    }

    public static interface AnalyticsRestApi {
        @FormUrlEncoded
        @POST(value="/login")
        public Call<LoginResult> login(@Field(value="data") String var1, @Field(value="session_key") String var2);

        @FormUrlEncoded
        @POST(value="/call")
        public Call<LoginResult> call(@Field(value="data") String var1, @Field(value="session_key") String var2);
    }
}

