/*
 * Decompiled with CFR 0.152.
 */
package org.socialsignin.spring.data.dynamodb.repository.query;

import java.lang.reflect.Method;
import java.util.Optional;
import org.socialsignin.spring.data.dynamodb.repository.EnableScan;
import org.socialsignin.spring.data.dynamodb.repository.EnableScanCount;
import org.socialsignin.spring.data.dynamodb.repository.Query;
import org.socialsignin.spring.data.dynamodb.repository.QueryConstants;
import org.socialsignin.spring.data.dynamodb.repository.support.DynamoDBEntityInformation;
import org.socialsignin.spring.data.dynamodb.repository.support.DynamoDBEntityMetadataSupport;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.util.StringUtils;

public class DynamoDBQueryMethod<T, ID>
extends QueryMethod {
    private final Method method;
    private final boolean scanEnabledForRepository;
    private final boolean scanCountEnabledForRepository;
    private final Optional<String> projectionExpression;
    private final Optional<Integer> limitResults;
    private QueryConstants.ConsistentReadMode consistentReadMode;

    public DynamoDBQueryMethod(Method method, RepositoryMetadata metadata, ProjectionFactory factory) {
        super(method, metadata, factory);
        this.method = method;
        this.scanEnabledForRepository = metadata.getRepositoryInterface().isAnnotationPresent(EnableScan.class);
        this.scanCountEnabledForRepository = metadata.getRepositoryInterface().isAnnotationPresent(EnableScanCount.class);
        Query query = method.getAnnotation(Query.class);
        if (query != null) {
            String projections = query.fields();
            this.projectionExpression = !StringUtils.isEmpty((Object)projections) ? Optional.of(query.fields()) : Optional.empty();
            int limit = query.limit();
            this.limitResults = limit != Integer.MIN_VALUE ? Optional.of(query.limit()) : Optional.empty();
            this.consistentReadMode = query.consistentReads();
        } else {
            this.projectionExpression = Optional.empty();
            this.limitResults = Optional.empty();
            this.consistentReadMode = QueryConstants.ConsistentReadMode.DEFAULT;
        }
    }

    Class<?> getReturnType() {
        return this.method.getReturnType();
    }

    public boolean isScanEnabled() {
        return this.scanEnabledForRepository || this.method.isAnnotationPresent(EnableScan.class);
    }

    public boolean isScanCountEnabled() {
        return this.scanCountEnabledForRepository || this.method.isAnnotationPresent(EnableScanCount.class);
    }

    public DynamoDBEntityInformation<T, ID> getEntityInformation() {
        return new DynamoDBEntityMetadataSupport(this.getDomainClass()).getEntityInformation();
    }

    public Class<T> getEntityType() {
        return this.getEntityInformation().getJavaType();
    }

    public Optional<String> getProjectionExpression() {
        return this.projectionExpression;
    }

    public Optional<Integer> getLimitResults() {
        return this.limitResults;
    }

    public QueryConstants.ConsistentReadMode getConsistentReadMode() {
        return this.consistentReadMode;
    }
}

