/*
 * Decompiled with CFR 0.152.
 */
package org.socialsignin.spring.data.dynamodb.repository.config;

import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.lang.Nullable;

public class DynamoDBMapperConfigFactory
implements FactoryBean<DynamoDBMapperConfig>,
BeanPostProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamoDBMapperConfigFactory.class);

    public DynamoDBMapperConfig getObject() throws Exception {
        return DynamoDBMapperConfig.DEFAULT;
    }

    public Class<?> getObjectType() {
        return DynamoDBMapperConfig.class;
    }

    @Nullable
    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof DynamoDBMapperConfig) {
            DynamoDBMapperConfig dynamoDBMapperConfig = (DynamoDBMapperConfig)bean;
            if (dynamoDBMapperConfig == DynamoDBMapperConfig.DEFAULT) {
                return bean;
            }
            DynamoDBMapperConfig.Builder emptyBuilder = DynamoDBMapperConfig.builder();
            if (dynamoDBMapperConfig.getConversionSchema() == null) {
                LOGGER.warn("No ConversionSchema set in the provided dynamoDBMapperConfig! Merging with DynamoDBMapperConfig.DEFAULT - Please see https://git.io/DynamoDBMapperConfig");
                emptyBuilder.withConversionSchema(DynamoDBMapperConfig.DEFAULT.getConversionSchema());
            }
            if (dynamoDBMapperConfig.getTypeConverterFactory() == null) {
                LOGGER.warn("No TypeConverterFactory set in the provided dynamoDBMapperConfig! Merging with DynamoDBMapperConfig.DEFAULT - Please see https://git.io/DynamoDBMapperConfig");
                emptyBuilder.withTypeConverterFactory(DynamoDBMapperConfig.DEFAULT.getTypeConverterFactory());
            }
            return this.createDynamoDBMapperConfig(dynamoDBMapperConfig, emptyBuilder);
        }
        return bean;
    }

    private DynamoDBMapperConfig createDynamoDBMapperConfig(DynamoDBMapperConfig dynamoDBMapperConfig, DynamoDBMapperConfig.Builder emptyBuilder) {
        return new DynamoDBMapperConfig(dynamoDBMapperConfig, emptyBuilder.build());
    }
}

