/*
 * Decompiled with CFR 0.152.
 */
package org.socialsignin.spring.data.dynamodb.repository.support;

import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMarshaller;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import org.socialsignin.spring.data.dynamodb.repository.support.DynamoDBHashAndRangeKeyExtractingEntityMetadata;
import org.socialsignin.spring.data.dynamodb.repository.support.DynamoDBIdIsHashAndRangeKeyEntityInformation;
import org.socialsignin.spring.data.dynamodb.repository.support.HashAndRangeKeyExtractor;
import org.springframework.data.annotation.Id;
import org.springframework.data.repository.core.support.ReflectionEntityInformation;

public class DynamoDBIdIsHashAndRangeKeyEntityInformationImpl<T, ID extends Serializable>
extends ReflectionEntityInformation<T, ID>
implements DynamoDBIdIsHashAndRangeKeyEntityInformation<T, ID> {
    private DynamoDBHashAndRangeKeyExtractingEntityMetadata<T, ID> metadata;
    private HashAndRangeKeyExtractor<ID, ?> hashAndRangeKeyExtractor;

    public DynamoDBIdIsHashAndRangeKeyEntityInformationImpl(Class<T> domainClass, DynamoDBHashAndRangeKeyExtractingEntityMetadata<T, ID> metadata) {
        super(domainClass, Id.class);
        this.metadata = metadata;
        this.hashAndRangeKeyExtractor = metadata.getHashAndRangeKeyExtractor(this.getIdType());
    }

    @Override
    public boolean isRangeKeyAware() {
        return true;
    }

    @Override
    public Object getHashKey(ID id) {
        return this.hashAndRangeKeyExtractor.getHashKey(id);
    }

    @Override
    public Object getRangeKey(ID id) {
        return this.hashAndRangeKeyExtractor.getRangeKey(id);
    }

    @Override
    public String getOverriddenAttributeName(String attributeName) {
        return this.metadata.getOverriddenAttributeName(attributeName);
    }

    @Override
    public boolean isHashKeyProperty(String propertyName) {
        return this.metadata.isHashKeyProperty(propertyName);
    }

    @Override
    public boolean isCompositeHashAndRangeKeyProperty(String propertyName) {
        return this.metadata.isCompositeHashAndRangeKeyProperty(propertyName);
    }

    @Override
    public String getRangeKeyPropertyName() {
        return this.metadata.getRangeKeyPropertyName();
    }

    @Override
    public DynamoDBMarshaller<?> getMarshallerForProperty(String propertyName) {
        return this.metadata.getMarshallerForProperty(propertyName);
    }

    @Override
    public Set<String> getIndexRangeKeyPropertyNames() {
        return this.metadata.getIndexRangeKeyPropertyNames();
    }

    @Override
    public String getHashKeyPropertyName() {
        return this.metadata.getHashKeyPropertyName();
    }

    @Override
    public <H> HashAndRangeKeyExtractor<ID, H> getHashAndRangeKeyExtractor(Class<ID> idClass) {
        return this.metadata.getHashAndRangeKeyExtractor(idClass);
    }

    @Override
    public String getDynamoDBTableName() {
        return this.metadata.getDynamoDBTableName();
    }

    @Override
    public Map<String, String[]> getGlobalSecondaryIndexNamesByPropertyName() {
        return this.metadata.getGlobalSecondaryIndexNamesByPropertyName();
    }

    @Override
    public <H> T getHashKeyPropotypeEntityForHashKey(H hashKey) {
        return this.metadata.getHashKeyPropotypeEntityForHashKey(hashKey);
    }

    @Override
    public boolean isGlobalIndexHashKeyProperty(String propertyName) {
        return this.metadata.isGlobalIndexHashKeyProperty(propertyName);
    }

    @Override
    public boolean isGlobalIndexRangeKeyProperty(String propertyName) {
        return this.metadata.isGlobalIndexRangeKeyProperty(propertyName);
    }
}

