/*
 * Decompiled with CFR 0.152.
 */
package org.socialsignin.spring.data.dynamodb.repository.support;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.springframework.data.annotation.Id;
import org.springframework.data.repository.core.support.AbstractEntityInformation;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class FieldAndGetterReflectionEntityInformation<T, ID extends Serializable>
extends AbstractEntityInformation<T, ID> {
    private static final Class<Id> DEFAULT_ID_ANNOTATION = Id.class;
    protected Method method;
    private Field field;

    public FieldAndGetterReflectionEntityInformation(Class<T> domainClass) {
        this(domainClass, DEFAULT_ID_ANNOTATION);
    }

    public FieldAndGetterReflectionEntityInformation(Class<T> domainClass, final Class<? extends Annotation> annotation) {
        super(domainClass);
        Assert.notNull(annotation, (String)"annotation must not be null!");
        ReflectionUtils.doWithMethods(domainClass, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) {
                if (method.getAnnotation(annotation) != null) {
                    FieldAndGetterReflectionEntityInformation.this.method = method;
                    return;
                }
            }
        });
        if (this.method == null) {
            ReflectionUtils.doWithFields(domainClass, (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

                public void doWith(Field field) {
                    if (field.getAnnotation(annotation) != null) {
                        FieldAndGetterReflectionEntityInformation.this.field = field;
                        return;
                    }
                }
            });
        }
        Assert.isTrue((this.method != null || this.field != null ? 1 : 0) != 0, (String)String.format("No field or method annotated with %s found!", annotation.toString()));
        Assert.isTrue((this.method == null || this.field == null ? 1 : 0) != 0, (String)String.format("Both field and method annotated with %s found!", annotation.toString()));
        if (this.method != null) {
            ReflectionUtils.makeAccessible((Method)this.method);
        }
    }

    public ID getId(T entity) {
        if (this.method != null) {
            return (ID)(entity == null ? null : (Serializable)ReflectionUtils.invokeMethod((Method)this.method, entity));
        }
        return (ID)(entity == null ? null : (Serializable)ReflectionUtils.getField((Field)this.field, entity));
    }

    public Class<ID> getIdType() {
        return this.method != null ? this.method.getReturnType() : this.field.getType();
    }
}

