/*
 * Decompiled with CFR 0.152.
 */
package org.socialsignin.spring.data.dynamodb.mapping.event;

import org.socialsignin.spring.data.dynamodb.mapping.event.AbstractDynamoDBEventListener;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.data.auditing.IsNewAwareAuditingHandler;
import org.springframework.util.Assert;

public class AuditingEventListener
extends AbstractDynamoDBEventListener<Object> {
    private final ObjectFactory<IsNewAwareAuditingHandler> auditingHandlerFactory;

    public AuditingEventListener(ObjectFactory<IsNewAwareAuditingHandler> auditingHandlerFactory) {
        Assert.notNull(auditingHandlerFactory, (String)"IsNewAwareAuditingHandler must not be null!");
        this.auditingHandlerFactory = auditingHandlerFactory;
    }

    @Override
    public void onBeforeSave(Object source) {
        ((IsNewAwareAuditingHandler)this.auditingHandlerFactory.getObject()).markAudited(source);
    }
}

