/*
 * Decompiled with CFR 0.152.
 */
package org.socialsignin.spring.data.dynamodb.config;

import java.lang.annotation.Annotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.socialsignin.spring.data.dynamodb.config.EnableDynamoDBAuditing;
import org.socialsignin.spring.data.dynamodb.mapping.DynamoDBMappingContext;
import org.socialsignin.spring.data.dynamodb.mapping.event.AuditingEventListener;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.auditing.IsNewAwareAuditingHandler;
import org.springframework.data.auditing.config.AuditingBeanDefinitionRegistrarSupport;
import org.springframework.data.auditing.config.AuditingConfiguration;
import org.springframework.data.config.ParsingUtils;
import org.springframework.util.Assert;

class DynamoDBAuditingRegistrar
extends AuditingBeanDefinitionRegistrarSupport {
    private static Logger LOGGER = LoggerFactory.getLogger(DynamoDBAuditingRegistrar.class);

    DynamoDBAuditingRegistrar() {
    }

    protected Class<? extends Annotation> getAnnotation() {
        return EnableDynamoDBAuditing.class;
    }

    protected String getAuditingHandlerBeanName() {
        return "dynamoDBAuditingHandler";
    }

    public void registerBeanDefinitions(AnnotationMetadata annotationMetadata, BeanDefinitionRegistry registry) {
        LOGGER.trace("registerBeanDefinitions");
        Assert.notNull((Object)annotationMetadata, (String)"AnnotationMetadata must not be null!");
        Assert.notNull((Object)registry, (String)"BeanDefinitionRegistry must not be null!");
        this.defaultDependenciesIfNecessary(registry, annotationMetadata);
        super.registerBeanDefinitions(annotationMetadata, registry);
    }

    protected BeanDefinitionBuilder getAuditHandlerBeanDefinitionBuilder(AuditingConfiguration configuration) {
        LOGGER.trace("getAuditHandlerBeanDefinitionBuilder");
        Assert.notNull((Object)configuration, (String)"AuditingConfiguration must not be null!");
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(IsNewAwareAuditingHandler.class);
        builder.addConstructorArgReference("dynamoDBMappingContext");
        return this.configureDefaultAuditHandlerAttributes(configuration, builder);
    }

    protected void registerAuditListenerBeanDefinition(BeanDefinition auditingHandlerDefinition, BeanDefinitionRegistry registry) {
        LOGGER.trace("registerAuditListenerBeanDefinition");
        Assert.notNull((Object)auditingHandlerDefinition, (String)"BeanDefinition must not be null!");
        Assert.notNull((Object)registry, (String)"BeanDefinitionRegistry must not be null!");
        BeanDefinitionBuilder listenerBeanDefinitionBuilder = BeanDefinitionBuilder.rootBeanDefinition(AuditingEventListener.class);
        listenerBeanDefinitionBuilder.addConstructorArgValue((Object)ParsingUtils.getObjectFactoryBeanDefinition((String)this.getAuditingHandlerBeanName(), (Object)registry));
        this.registerInfrastructureBeanWithId(listenerBeanDefinitionBuilder.getBeanDefinition(), AuditingEventListener.class.getName(), registry);
    }

    private void defaultDependenciesIfNecessary(BeanDefinitionRegistry registry, Object source) {
        LOGGER.trace("defaultDependenciesIfNecessary. source:{}", source);
        LOGGER.trace("is registry.containsBeanDefinition {} {}", (Object)"dynamoDBMappingContext", (Object)registry.containsBeanDefinition("dynamoDBMappingContext"));
        if (!registry.containsBeanDefinition("dynamoDBMappingContext")) {
            RootBeanDefinition definition = new RootBeanDefinition(DynamoDBMappingContext.class);
            definition.setRole(2);
            definition.setSource(source);
            registry.registerBeanDefinition("dynamoDBMappingContext", (BeanDefinition)definition);
        }
    }
}

