/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm.online;

import io.github.bonigarcia.wdm.config.Architecture;
import io.github.bonigarcia.wdm.config.Config;
import io.github.bonigarcia.wdm.config.OperatingSystem;
import io.github.bonigarcia.wdm.config.WebDriverManagerException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlHandler {
    public static final String ALPHA = "alpha";
    public static final String BETA = "beta";
    final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    Config config;
    List<URL> candidateUrls;
    String driverVersion;
    String shortDriverName;
    Function<String, Optional<URL>> buildUrlFunction;

    public UrlHandler(Config config, List<URL> candidateUrls, String driverVersion, String shortDriverName, Function<String, Optional<URL>> buildUrlFunction) {
        this.config = config;
        this.candidateUrls = candidateUrls;
        this.driverVersion = driverVersion;
        this.shortDriverName = shortDriverName;
        this.buildUrlFunction = buildUrlFunction;
    }

    public void filterByDriverName(String driverName) {
        this.candidateUrls = this.candidateUrls.stream().filter(url -> url.getFile().contains(driverName) && !url.getFile().contains("-symbols")).collect(Collectors.toList());
    }

    public void filterByVersion(String driverVersion) {
        this.driverVersion = driverVersion;
        this.candidateUrls = this.candidateUrls.stream().filter(url -> url.getFile().contains(driverVersion)).collect(Collectors.toList());
    }

    public void filterByLatestVersion(Function<URL, String> getCurrentVersion) {
        this.log.trace("Checking the lastest version using URL list {}", this.candidateUrls);
        ArrayList<URL> out = new ArrayList<URL>();
        ArrayList<URL> copyOfList = new ArrayList<URL>(this.candidateUrls);
        String foundFriverVersion = null;
        for (URL url : copyOfList) {
            try {
                if (this.isNotStable(url)) continue;
                String currentVersion = getCurrentVersion.apply(url);
                if (Config.isNullOrEmpty(foundFriverVersion)) {
                    foundFriverVersion = currentVersion;
                }
                if (this.versionCompare(currentVersion, foundFriverVersion) > 0) {
                    foundFriverVersion = currentVersion;
                    out.clear();
                }
                if (!url.getFile().contains(foundFriverVersion)) continue;
                out.add(url);
            }
            catch (Exception e) {
                this.log.trace("There was a problem with URL {} : {}", (Object)url, (Object)e.getMessage());
                this.candidateUrls.remove(url);
            }
        }
        this.driverVersion = foundFriverVersion;
        this.candidateUrls = out;
    }

    public void filterByBeta(boolean useBeta) {
        if (!useBeta) {
            this.log.trace("URLs before filtering by beta versions: {}", this.candidateUrls);
            this.candidateUrls = this.candidateUrls.stream().filter(url -> {
                String fileLowerCase = url.getFile().toLowerCase(Locale.ROOT);
                return !fileLowerCase.contains(BETA) && !fileLowerCase.contains(ALPHA);
            }).collect(Collectors.toList());
            this.log.trace("URLs after filtering by beta versions: {}", this.candidateUrls);
        }
    }

    public void filterByOs(String driverName, String osName) {
        if (!driverName.equalsIgnoreCase("IEDriverServer") && !driverName.equalsIgnoreCase("selenium-server-standalone")) {
            this.log.trace("URLs before filtering by OS ({}): {}", (Object)osName, this.candidateUrls);
            this.candidateUrls = this.candidateUrls.stream().filter(url -> OperatingSystem.valueOf(osName).matchOs(url.getFile())).collect(Collectors.toList());
            this.log.trace("URLs after filtering by OS ({}): {}", (Object)osName, this.candidateUrls);
        }
    }

    public void filterByArch(Architecture arch, boolean forcedArch) {
        this.log.trace("URLs before filtering by architecture ({}): {}", (Object)arch, this.candidateUrls);
        if ((forcedArch || this.candidateUrls.size() > 1) && arch != null) {
            this.candidateUrls = this.candidateUrls.stream().filter(arch::matchUrl).collect(Collectors.toList());
        }
        this.log.trace("URLs after filtering by architecture ({}): {}", (Object)arch, this.candidateUrls);
        if (this.candidateUrls.isEmpty() && !forcedArch && !this.candidateUrls.isEmpty()) {
            this.candidateUrls = Collections.singletonList(this.candidateUrls.get(this.candidateUrls.size() - 1));
            this.log.trace("Empty URL list after filtering by architecture ... using last candidate: {}", this.candidateUrls);
        }
    }

    public void filterByDistro(String os, String driverName) throws IOException {
        String distro = this.getDistroName();
        if (os.equalsIgnoreCase("linux") && driverName.contains("phantomjs")) {
            String versionToFilter = "2.5.0";
            this.log.trace("URLs before filtering by Linux distribution ({}): {}", (Object)distro, this.candidateUrls);
            this.candidateUrls = this.candidateUrls.stream().filter(url -> !url.getFile().contains(versionToFilter) || url.getFile().contains(distro)).collect(Collectors.toList());
            this.log.trace("URLs after filtering by Linux distribution ({}): {}", (Object)distro, this.candidateUrls);
        }
    }

    public void filterByIgnoredVersions(List<String> ignoredVersions) {
        if (!ignoredVersions.isEmpty() && !this.candidateUrls.isEmpty()) {
            this.log.trace("URLs before filtering by ignored versions ({}): {}", ignoredVersions, this.candidateUrls);
            this.candidateUrls = this.candidateUrls.stream().filter(url -> ignoredVersions.stream().noneMatch(version -> url.getFile().contains((CharSequence)version))).collect(Collectors.toList());
            this.log.trace("URLs after filtering by ignored versions ({}): {}", ignoredVersions, this.candidateUrls);
        }
    }

    public String getDistroName() throws IOException {
        File fileVersion;
        String out = "";
        String key = "UBUNTU_CODENAME";
        File dir = new File(File.separator + "etc");
        File[] fileList = new File[]{};
        if (dir.exists()) {
            fileList = dir.listFiles((path, filename) -> filename.endsWith("-release"));
        }
        if ((fileVersion = new File(File.separator + "proc", "version")).exists()) {
            fileList = Arrays.copyOf(fileList, fileList.length + 1);
            fileList[fileList.length - 1] = fileVersion;
        }
        for (File f : fileList) {
            if (f.isDirectory()) continue;
            try (BufferedReader myReader = new BufferedReader(new FileReader(f));){
                String strLine = null;
                while ((strLine = myReader.readLine()) != null) {
                    if (!strLine.contains("UBUNTU_CODENAME")) continue;
                    int beginIndex = "UBUNTU_CODENAME".length();
                    out = strLine.substring(beginIndex + 1);
                }
            }
        }
        return out;
    }

    public void resetList(List<URL> newCandidateUrls) {
        this.candidateUrls = newCandidateUrls.stream().filter(url -> !url.getFile().contains(this.driverVersion)).collect(Collectors.toList());
    }

    public boolean isNotStable(URL url) {
        String fileLowerCase = url.getFile().toLowerCase(Locale.ROOT);
        return !this.config.isUseMirror() && (fileLowerCase.contains(BETA) || fileLowerCase.contains(ALPHA));
    }

    public Integer versionCompare(String str1, String str2) {
        int i;
        String[] vals1 = str1.replace("v", "").replace("-beta", "").split("\\.");
        String[] vals2 = str2.replace("v", "").replace("-beta", "").split("\\.");
        if (vals1[0].equals("")) {
            vals1[0] = "0";
        }
        if (vals2[0].equals("")) {
            vals2[0] = "0";
        }
        for (i = 0; i < vals1.length && i < vals2.length && vals1[i].equals(vals2[i]); ++i) {
        }
        if (i < vals1.length && i < vals2.length) {
            return Integer.signum(Integer.valueOf(vals1[i]).compareTo(Integer.valueOf(vals2[i])));
        }
        return Integer.signum(vals1.length - vals2.length);
    }

    public List<URL> getCandidateUrls() {
        return this.candidateUrls;
    }

    public String getDriverVersion() {
        return this.driverVersion;
    }

    public boolean hasNoCandidateUrl() {
        return this.candidateUrls.isEmpty();
    }

    public URL getCandidateUrl() {
        if (this.hasNoCandidateUrl()) {
            Optional<URL> buildUrl = this.buildUrlFunction.apply(this.driverVersion);
            if (buildUrl.isPresent()) {
                URL url = buildUrl.get();
                Stream ignoredVersionsStream = this.config.getIgnoreVersions().stream();
                if (ignoredVersionsStream.noneMatch(url.getFile()::contains)) {
                    return url;
                }
            }
            String driverVersionLabel = Config.isNullOrEmpty(this.driverVersion) ? "" : " " + this.driverVersion;
            String errorMessage = String.format("No proper candidate URL to download %s%s", this.shortDriverName, driverVersionLabel);
            throw new WebDriverManagerException(errorMessage);
        }
        return this.candidateUrls.iterator().next();
    }
}

